/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.client;

import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.Riddle;
import de.sfuhrm.sudoku.Solver;
import de.sfuhrm.sudoku.output.GameMatrixFormatter;
import de.sfuhrm.sudoku.output.LatexTableFormatter;
import de.sfuhrm.sudoku.output.MarkdownTableFormatter;
import de.sfuhrm.sudoku.output.PlainTextFormatter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Client {
    @Option(name="-n", aliases={"-count"}, usage="The number of outputs to create")
    private int count = 1;
    @Option(name="-f", aliases={"-format"}, usage="The output format to use")
    private Formatter format = Formatter.PlainText;
    @Option(name="-e", aliases={"-exec"}, usage="The operation to perform")
    private Op op = Op.Full;
    @Option(name="-t", aliases={"-time"}, usage="Show timing information")
    private boolean timing;
    @Option(name="-q", aliases={"-quiet"}, usage="No output")
    private boolean quiet;
    @Option(name="-i", aliases={"-input"}, usage="Input file to read for solving")
    private Path input;
    @Option(name="-h", aliases={"-help"}, usage="Show this command line help")
    private boolean help;

    private void solve(GameMatrixFormatter formatter) throws FileNotFoundException, IOException {
        if (this.op == Op.Solve && this.input == null) {
            throw new IllegalArgumentException("Expecting input file for Solve");
        }
        List<String> lines = Files.readAllLines(this.input);
        lines.stream().filter(l -> !l.isEmpty()).map(l -> l.replaceAll("[_?.]", "0")).collect(Collectors.toList());
        byte[][] data = GameMatrix.parse((String[])lines.toArray(new String[0]));
        Riddle riddle = new Riddle();
        riddle.setAll(data);
        Solver solver = new Solver(riddle);
        List sollutions = solver.solve();
        if (!this.quiet) {
            for (Riddle r : sollutions) {
                System.out.println(formatter.format((GameMatrix)r));
            }
        }
    }

    private void run() throws IOException {
        GameMatrixFormatter formatter = this.format.newInstance();
        long start = System.currentTimeMillis();
        if (!this.quiet) {
            System.out.print(formatter.documentStart());
        }
        if (this.op == Op.Solve) {
            this.solve(formatter);
        } else {
            block5: for (int i = 0; i < this.count; ++i) {
                switch (this.op) {
                    case Full: {
                        GameMatrix matrix = Creator.createFull();
                        if (this.quiet) continue block5;
                        System.out.print(formatter.format(matrix));
                        continue block5;
                    }
                    case Riddle: {
                        GameMatrix matrix = Creator.createFull();
                        Riddle riddle = Creator.createRiddle((GameMatrix)matrix);
                        if (this.quiet) continue block5;
                        System.out.print(formatter.format((GameMatrix)riddle));
                        continue block5;
                    }
                    case Both: {
                        GameMatrix matrix = Creator.createFull();
                        Riddle riddle = Creator.createRiddle((GameMatrix)matrix);
                        if (!this.quiet) {
                            System.out.print(formatter.format((GameMatrix)riddle));
                        }
                        if (this.quiet) continue block5;
                        System.out.print(formatter.format(matrix));
                        continue block5;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled case " + (Object)((Object)this.op));
                    }
                }
            }
        }
        long end = System.currentTimeMillis();
        if (!this.quiet) {
            System.out.print(formatter.documentEnd());
        }
        if (this.timing) {
            System.err.println("Took total of " + (end - start) + "ms");
            System.err.println("Each iteration took " + (end - start) / (long)this.count + "ms");
        }
    }

    public static void main(String[] args) throws CmdLineException, IOException {
        Client client = new Client();
        CmdLineParser parser = new CmdLineParser((Object)client);
        parser.parseArgument(args);
        if (client.help) {
            parser.printUsage((OutputStream)System.out);
            return;
        }
        client.run();
    }

    static enum Formatter {
        PlainText(PlainTextFormatter.class),
        MarkDownTable(MarkdownTableFormatter.class),
        LatexTable(LatexTableFormatter.class);

        private final Class<? extends GameMatrixFormatter> clazz;

        private Formatter(Class<? extends GameMatrixFormatter> inClazz) {
            this.clazz = inClazz;
        }

        public GameMatrixFormatter newInstance() {
            try {
                return this.clazz.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                throw new IllegalStateException(ex);
            }
        }
    }

    static enum Op {
        Full,
        Riddle,
        Both,
        Solve;

    }
}

