/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.sudoku.client;

import de.sfuhrm.sudoku.Creator;
import de.sfuhrm.sudoku.GameMatrix;
import de.sfuhrm.sudoku.Riddle;
import java.io.OutputStream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class Client {
    @Option(name="-n", aliases={"-count"}, usage="The number of outputs to create")
    private int count = 1;
    @Option(name="-e", aliases={"-exec"}, usage="The operation to perform")
    private Op op = Op.Full;
    @Option(name="-t", aliases={"-time"}, usage="Show timing information")
    private boolean timing;
    @Option(name="-q", aliases={"-quiet"}, usage="No output")
    private boolean quiet;
    @Option(name="-h", aliases={"-help"}, usage="Show this command line help")
    private boolean help;

    private void run() {
        long start = System.currentTimeMillis();
        block4: for (int i = 0; i < this.count; ++i) {
            switch (this.op) {
                case Full: {
                    GameMatrix matrix = Creator.createFull();
                    if (this.quiet) continue block4;
                    System.out.println(matrix);
                    continue block4;
                }
                case Riddle: {
                    GameMatrix matrix = Creator.createFull();
                    Riddle riddle = Creator.createRiddle((GameMatrix)matrix);
                    if (this.quiet) continue block4;
                    System.out.println(riddle);
                    continue block4;
                }
            }
        }
        long end = System.currentTimeMillis();
        if (this.timing) {
            System.err.println("Took total of " + (end - start) + "ms");
            System.err.println("Each iteration took " + (end - start) / (long)this.count + "ms");
        }
    }

    public static void main(String[] args) throws CmdLineException {
        Client client = new Client();
        CmdLineParser parser = new CmdLineParser((Object)client);
        parser.parseArgument(args);
        if (client.help) {
            parser.printUsage((OutputStream)System.out);
            return;
        }
        client.run();
    }

    static enum Op {
        Full,
        Riddle;

    }
}

