/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash.spi;

import fr.cryptohash.Digest;
import java.security.DigestException;
import java.security.MessageDigestSpi;

class GenericAdapterSpi
extends MessageDigestSpi
implements Cloneable {
    private final Digest messageDigest;

    protected GenericAdapterSpi(Digest messageDigest) {
        if (messageDigest == null) {
            throw new NullPointerException("messageDigest is null");
        }
        this.messageDigest = messageDigest;
    }

    @Override
    protected int engineGetDigestLength() {
        return this.messageDigest.getDigestLength();
    }

    @Override
    protected final void engineUpdate(byte input) {
        this.messageDigest.update(input);
    }

    @Override
    protected final void engineUpdate(byte[] input, int offset, int len) {
        this.messageDigest.update(input, offset, len);
    }

    @Override
    protected final byte[] engineDigest() {
        return this.messageDigest.digest();
    }

    @Override
    protected int engineDigest(byte[] buf, int offset, int len) throws DigestException {
        return this.messageDigest.digest(buf, len, len);
    }

    @Override
    protected final void engineReset() {
        this.messageDigest.reset();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        if (this instanceof Cloneable) {
            return super.clone();
        }
        throw new CloneNotSupportedException();
    }
}

