/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.MDHelper;

abstract class SHA2BigCore
extends MDHelper {
    private static final long[] K = new long[]{4794697086780616226L, 8158064640168781261L, -5349999486874862801L, -1606136188198331460L, 4131703408338449720L, 6480981068601479193L, -7908458776815382629L, -6116909921290321640L, -2880145864133508542L, 1334009975649890238L, 2608012711638119052L, 6128411473006802146L, 8268148722764581231L, -9160688886553864527L, -7215885187991268811L, -4495734319001033068L, -1973867731355612462L, -1171420211273849373L, 1135362057144423861L, 2597628984639134821L, 3308224258029322869L, 5365058923640841347L, 6679025012923562964L, 8573033837759648693L, -7476448914759557205L, -6327057829258317296L, -5763719355590565569L, -4658551843659510044L, -4116276920077217854L, -3051310485924567259L, 489312712824947311L, 1452737877330783856L, 2861767655752347644L, 3322285676063803686L, 5560940570517711597L, 5996557281743188959L, 7280758554555802590L, 8532644243296465576L, -9096487096722542874L, -7894198246740708037L, -6719396339535248540L, -6333637450476146687L, -4446306890439682159L, -4076793802049405392L, -3345356375505022440L, -2983346525034927856L, -860691631967231958L, 1182934255886127544L, 1847814050463011016L, 2177327727835720531L, 2830643537854262169L, 3796741975233480872L, 4115178125766777443L, 5681478168544905931L, 6601373596472566643L, 7507060721942968483L, 8399075790359081724L, 8693463985226723168L, -8878714635349349518L, -8302665154208450068L, -8016688836872298968L, -6606660893046293015L, -4685533653050689259L, -4147400797238176981L, -3880063495543823972L, -3348786107499101689L, -1523767162380948706L, -757361751448694408L, 500013540394364858L, 748580250866718886L, 1242879168328830382L, 1977374033974150939L, 2944078676154940804L, 3659926193048069267L, 4368137639120453308L, 4836135668995329356L, 5532061633213252278L, 6448918945643986474L, 6902733635092675308L, 7801388544844847127L};
    private long[] currentVal;
    private long[] W;

    SHA2BigCore() {
        super(false, 16);
    }

    protected Digest copyState(SHA2BigCore dst) {
        System.arraycopy(this.currentVal, 0, dst.currentVal, 0, this.currentVal.length);
        return super.copyState(dst);
    }

    @Override
    public int getBlockLength() {
        return 128;
    }

    @Override
    protected void engineReset() {
        System.arraycopy(this.getInitVal(), 0, this.currentVal, 0, 8);
    }

    abstract long[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.makeMDPadding();
        int olen = this.getDigestLength();
        int i = 0;
        for (int j = 0; j < olen; j += 8) {
            SHA2BigCore.encodeBELong(this.currentVal[i], output, outputOffset + j);
            ++i;
        }
    }

    @Override
    protected void doInit() {
        this.currentVal = new long[8];
        this.W = new long[80];
        this.engineReset();
    }

    private static final void encodeBELong(long val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 56);
        buf[off + 1] = (byte)(val >>> 48);
        buf[off + 2] = (byte)(val >>> 40);
        buf[off + 3] = (byte)(val >>> 32);
        buf[off + 4] = (byte)(val >>> 24);
        buf[off + 5] = (byte)(val >>> 16);
        buf[off + 6] = (byte)(val >>> 8);
        buf[off + 7] = (byte)val;
    }

    private static final long decodeBELong(byte[] buf, int off) {
        return (long)(buf[off] & 0xFF) << 56 | (long)(buf[off + 1] & 0xFF) << 48 | (long)(buf[off + 2] & 0xFF) << 40 | (long)(buf[off + 3] & 0xFF) << 32 | (long)(buf[off + 4] & 0xFF) << 24 | (long)(buf[off + 5] & 0xFF) << 16 | (long)(buf[off + 6] & 0xFF) << 8 | (long)(buf[off + 7] & 0xFF);
    }

    private static long circularLeft(long x, int n) {
        return x << n | x >>> 64 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        int i;
        long A = this.currentVal[0];
        long B = this.currentVal[1];
        long C = this.currentVal[2];
        long D = this.currentVal[3];
        long E = this.currentVal[4];
        long F = this.currentVal[5];
        long G = this.currentVal[6];
        long H = this.currentVal[7];
        for (i = 0; i < 16; ++i) {
            this.W[i] = SHA2BigCore.decodeBELong(data, 8 * i);
        }
        for (i = 16; i < 80; ++i) {
            this.W[i] = (SHA2BigCore.circularLeft(this.W[i - 2], 45) ^ SHA2BigCore.circularLeft(this.W[i - 2], 3) ^ this.W[i - 2] >>> 6) + this.W[i - 7] + (SHA2BigCore.circularLeft(this.W[i - 15], 63) ^ SHA2BigCore.circularLeft(this.W[i - 15], 56) ^ this.W[i - 15] >>> 7) + this.W[i - 16];
        }
        for (i = 0; i < 80; ++i) {
            long T1 = SHA2BigCore.circularLeft(E, 50);
            T1 ^= SHA2BigCore.circularLeft(E, 46);
            T1 ^= SHA2BigCore.circularLeft(E, 23);
            T1 += H;
            T1 += F & E ^ G & (E ^ 0xFFFFFFFFFFFFFFFFL);
            T1 += K[i];
            T1 += this.W[i];
            long T2 = SHA2BigCore.circularLeft(A, 36);
            T2 ^= SHA2BigCore.circularLeft(A, 30);
            T2 ^= SHA2BigCore.circularLeft(A, 25);
            T2 += A & B ^ A & C ^ B & C;
            H = G;
            G = F;
            F = E;
            E = D + T1;
            D = C;
            C = B;
            B = A;
            A = T1 + T2;
        }
        this.currentVal[0] = this.currentVal[0] + A;
        this.currentVal[1] = this.currentVal[1] + B;
        this.currentVal[2] = this.currentVal[2] + C;
        this.currentVal[3] = this.currentVal[3] + D;
        this.currentVal[4] = this.currentVal[4] + E;
        this.currentVal[5] = this.currentVal[5] + F;
        this.currentVal[6] = this.currentVal[6] + G;
        this.currentVal[7] = this.currentVal[7] + H;
    }

    @Override
    public String toString() {
        return "SHA-" + (this.getDigestLength() << 3);
    }
}

