/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;

abstract class HamsiSmallCore
implements Digest {
    private int[] h = new int[8];
    private long bitCount;
    private int partial;
    private int partialLen;
    private static final int[][] Tsrc = new int[][]{{73334784, -1672834103, 1660713424, 1931394498, -534282240, 433905672, -687383166, 1523770141}, {-461864960, -2053737535, -1241832366, 701259487, 73334784, -1672834103, 1660713424, 1931394498}, {-430505984, 1270037029, -2071619398, 272695358, -196329472, 279241677, 159340305, -562574260}, {303775744, 1528289768, -1912942677, -835269518, -430505984, 1270037029, -2071619398, 272695358}, {-1756168192, 542076627, 2008672271, -1578344767, 2121867264, -1810308561, 1715720792, -1675273243}, {-383115264, -1269330692, 301611607, 1036584228, -1756168192, 542076627, 2008672271, -1578344767}, {-878116864, -1876478103, -1143147513, -789270687, -1086582784, -905154281, 857860396, -837669389}, {1955926016, 1512785534, -1996677845, 518423186, -878116864, -1876478103, -1143147513, -789270687}, {-510984192, 1415153789, -1089305645, 459696755, 1069090816, 2094717059, -828921580, -1109789211}, {-567146496, 679694590, 1904552647, -1497391210, -510984192, 1415153789, -1089305645, 459696755}, {347930624, 800733183, 1785914811, 612363238, -1685912576, 573046664, 95923546, -1376598224}, {-1891761152, 228444279, 1875200225, -1987236650, 347930624, 800733183, 1785914811, 612363238}, {-299499520, 306931774, -2134714737, 1005824812, 1235091968, 223996941, -534302851, -1511530918}, {-1481113088, 521307187, 1625684466, -1642826378, -299499520, 306931774, -2134714737, 1005824812}, {1934360576, -1787844650, -1566764393, 1860528212, -991428352, 527472142, 655673916, -2011100112}, {-1213988608, -1977667112, -2054563669, -423336860, 1934360576, -1787844650, -1566764393, 1860528212}, {967180288, 1253528555, -783414965, -1217219541, 1651769472, 263736071, 327836958, 1141900824}, {1540489344, 1158617324, -1027314603, -211635661, 967180288, 1253528555, -783414965, -1217219541}, {2024472576, -1597154764, 1566351607, 1920435403, 895811648, -1684621750, 1798949727, 1360314062}, {1305346112, 995880062, 912616360, 593705477, 2024472576, -1597154764, 1566351607, 1920435403}, {1550974976, -910504686, 2041122297, 1676222840, -20316128, 1214064868, -2140716547, -2126085704}, {-1564999648, -2115508746, -103920636, -491806528, 1550974976, -910504686, 2041122297, 1676222840}, {775487488, 1692231305, 1020528380, -1309372228, 2137325584, 606999666, -1070391042, -1063010083}, {1364983824, 1089696507, -51960318, 1901547617, 775487488, 1692231305, 1020528380, -1309372228}, {387710976, -1301400764, -1637186690, 1492666463, -1078853624, -1843983815, 1612255359, -531537810}, {-1464991736, 544815485, -25980159, -1196873679, 387710976, -1301400764, -1637186690, 1492666463}, {1806237696, 1089206698, -1741546435, 1991034675, -1147076604, -862095651, 100117613, -639176983}, {-804782076, -1938387081, -1647988656, -1354094118, 1806237696, 1089206698, -1741546435, 1991034675}, {1370226688, 635637524, 2044865100, 311999814, -644939774, 2047125671, -536367130, -1611838793}, {-2010972158, 1609017267, -1713011286, -1921648655, 1370226688, 635637524, 2044865100, 311999814}, {-923729920, 187557762, 1811302564, 1402781119, 146735105, 949233554, -973540447, -432505980}, {-1068630015, 867811344, -1374766331, -1247492549, -923729920, 187557762, 1811302564, 1402781119}};
    private static final int[][] T256_0 = HamsiSmallCore.makeT(0);
    private static final int[][] T256_1 = HamsiSmallCore.makeT(8);
    private static final int[][] T256_2 = HamsiSmallCore.makeT(16);
    private static final int[][] T256_3 = HamsiSmallCore.makeT(24);
    private static final int[] ALPHA_N = new int[]{-16715536, -859002198, -252654388, -16733526, -859002198, -252641536, -1431647028, -252641536, -252654388, -1431634176, -858980608, -1431637776, -1431637776, -16724788, -858984208, -16733526, -859002198, -16715536, -16733526, -252654388, -252641536, -859002198, -252641536, -1431647028, -1431634176, -252654388, -1431637776, -858980608, -16724788, -1431637776, -16733526, -858984208};
    private static final int[] ALPHA_F = new int[]{-889625700, 267450816, 1671172080, -889587264, 267450816, 1671219961, -104853520, 1671219961, 1671172080, -104805639, 267438841, -104832100, -104832100, -889647120, 267412380, -889587264, 267450816, -889625700, -889587264, 1671172080, 1671219961, 267450816, 1671219961, -104853520, -104805639, 1671172080, -104832100, 267438841, -889647120, -104832100, -889587264, 267412380};

    HamsiSmallCore() {
        this.reset();
    }

    @Override
    public void update(byte in) {
        this.bitCount += 8L;
        this.partial = this.partial << 8 | in & 0xFF;
        ++this.partialLen;
        if (this.partialLen == 4) {
            this.process(this.partial >>> 24, this.partial >>> 16 & 0xFF, this.partial >>> 8 & 0xFF, this.partial & 0xFF);
            this.partialLen = 0;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        this.bitCount += (long)len << 3;
        if (this.partialLen != 0) {
            while (this.partialLen < 4 && len > 0) {
                this.partial = this.partial << 8 | inbuf[off++] & 0xFF;
                ++this.partialLen;
                --len;
            }
            if (this.partialLen < 4) {
                return;
            }
            this.process(this.partial >>> 24, this.partial >>> 16 & 0xFF, this.partial >>> 8 & 0xFF, this.partial & 0xFF);
            this.partialLen = 0;
        }
        while (len >= 4) {
            this.process(inbuf[off + 0] & 0xFF, inbuf[off + 1] & 0xFF, inbuf[off + 2] & 0xFF, inbuf[off + 3] & 0xFF);
            off += 4;
            len -= 4;
        }
        this.partialLen = len;
        while (len-- > 0) {
            this.partial = this.partial << 8 | inbuf[off++] & 0xFF;
        }
    }

    @Override
    public byte[] digest() {
        int n = this.getDigestLength();
        byte[] out = new byte[n];
        this.digest(out, 0, n);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        long bitCount = this.bitCount;
        this.update((byte)-128);
        while (this.partialLen != 0) {
            this.update((byte)0);
        }
        this.process((int)(bitCount >>> 56) & 0xFF, (int)(bitCount >>> 48) & 0xFF, (int)(bitCount >>> 40) & 0xFF, (int)(bitCount >>> 32) & 0xFF);
        this.processFinal((int)bitCount >>> 24 & 0xFF, (int)bitCount >>> 16 & 0xFF, (int)bitCount >>> 8 & 0xFF, (int)bitCount & 0xFF);
        int n = this.getDigestLength();
        if (len > n) {
            len = n;
        }
        int ch = 0;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if ((i & 3) == 0) {
                ch = this.h[j++];
            }
            outbuf[off + i] = (byte)(ch >>> 24);
            ch <<= 8;
        }
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        System.arraycopy(this.getIV(), 0, this.h, 0, this.h.length);
        this.bitCount = 0L;
        this.partialLen = 0;
    }

    @Override
    public Digest copy() {
        HamsiSmallCore d = this.dup();
        System.arraycopy(this.h, 0, d.h, 0, this.h.length);
        d.bitCount = this.bitCount;
        d.partial = this.partial;
        d.partialLen = this.partialLen;
        return d;
    }

    @Override
    public int getBlockLength() {
        return -32;
    }

    abstract int[] getIV();

    abstract HamsiSmallCore dup();

    private static int[][] makeT(int x) {
        int[][] T = new int[256][8];
        for (int y = 0; y < 256; ++y) {
            for (int z = 0; z < 8; ++z) {
                int a = 0;
                for (int k = 0; k < 8; ++k) {
                    if ((y & 1 << 7 - k) == 0) continue;
                    a ^= Tsrc[x + k][z];
                }
                T[y][z] = a;
            }
        }
        return T;
    }

    private void process(int b0, int b1, int b2, int b3) {
        int[] rp = T256_0[b0];
        int m0 = rp[0];
        int m1 = rp[1];
        int m2 = rp[2];
        int m3 = rp[3];
        int m4 = rp[4];
        int m5 = rp[5];
        int m6 = rp[6];
        int m7 = rp[7];
        rp = T256_1[b1];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        rp = T256_2[b2];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        rp = T256_3[b3];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        int c0 = this.h[0];
        int c1 = this.h[1];
        int c2 = this.h[2];
        int c3 = this.h[3];
        int c4 = this.h[4];
        int c5 = this.h[5];
        int c6 = this.h[6];
        int c7 = this.h[7];
        m0 ^= ALPHA_N[0];
        m1 ^= ALPHA_N[1] ^ 0;
        c0 ^= ALPHA_N[2];
        c1 ^= ALPHA_N[3];
        c2 ^= ALPHA_N[8];
        c3 ^= ALPHA_N[9];
        m2 ^= ALPHA_N[10];
        m3 ^= ALPHA_N[11];
        m4 ^= ALPHA_N[16];
        m5 ^= ALPHA_N[17];
        c4 ^= ALPHA_N[18];
        c5 ^= ALPHA_N[19];
        c6 ^= ALPHA_N[24];
        c7 ^= ALPHA_N[25];
        m6 ^= ALPHA_N[26];
        m7 ^= ALPHA_N[27];
        int t = m0;
        m0 &= m4;
        m4 ^= c2;
        m4 ^= (m0 ^= c6);
        c6 |= t;
        c6 ^= c2;
        c2 = c6;
        c6 |= (t ^= m4);
        c6 ^= m0;
        t ^= (m0 &= c2);
        c2 ^= c6;
        m0 = m4;
        m4 = c2 ^= t;
        c2 = c6;
        c6 = ~t;
        t = m1;
        m1 &= m5;
        m5 ^= c3;
        m5 ^= (m1 ^= c7);
        c7 |= t;
        c7 ^= c3;
        c3 = c7;
        c7 |= (t ^= m5);
        c7 ^= m1;
        t ^= (m1 &= c3);
        c3 ^= c7;
        m1 = m5;
        m5 = c3 ^= t;
        c3 = c7;
        c7 = ~t;
        t = c0;
        c0 &= c4;
        c4 ^= m2;
        c4 ^= (c0 ^= m6);
        m6 |= t;
        m6 ^= m2;
        m2 = m6;
        m6 |= (t ^= c4);
        m6 ^= c0;
        t ^= (c0 &= m2);
        m2 ^= m6;
        c0 = c4;
        c4 = m2 ^= t;
        m2 = m6;
        m6 = ~t;
        t = c1;
        c1 &= c5;
        c5 ^= m3;
        c5 ^= (c1 ^= m7);
        m7 |= t;
        m7 ^= m3;
        m3 = m7;
        m7 |= (t ^= c5);
        m7 ^= c1;
        t ^= (c1 &= m3);
        m3 ^= m7;
        c1 = c5;
        c5 = m3 ^= t;
        m3 = m7;
        m7 = ~t;
        m0 = m0 << 13 | m0 >>> 19;
        c4 = c4 << 3 | c4 >>> 29;
        c3 ^= m0 ^ c4;
        m7 ^= c4 ^ m0 << 3;
        c3 = c3 << 1 | c3 >>> 31;
        m7 = m7 << 7 | m7 >>> 25;
        m0 ^= c3 ^ m7;
        c4 ^= m7 ^ c3 << 7;
        m0 = m0 << 5 | m0 >>> 27;
        c4 = c4 << 22 | c4 >>> 10;
        m1 = m1 << 13 | m1 >>> 19;
        c5 = c5 << 3 | c5 >>> 29;
        m2 ^= m1 ^ c5;
        c6 ^= c5 ^ m1 << 3;
        m2 = m2 << 1 | m2 >>> 31;
        c6 = c6 << 7 | c6 >>> 25;
        m1 ^= m2 ^ c6;
        c5 ^= c6 ^ m2 << 7;
        m1 = m1 << 5 | m1 >>> 27;
        c5 = c5 << 22 | c5 >>> 10;
        c0 = c0 << 13 | c0 >>> 19;
        m4 = m4 << 3 | m4 >>> 29;
        m3 ^= c0 ^ m4;
        c7 ^= m4 ^ c0 << 3;
        m3 = m3 << 1 | m3 >>> 31;
        c7 = c7 << 7 | c7 >>> 25;
        c0 ^= m3 ^ c7;
        m4 ^= c7 ^ m3 << 7;
        c0 = c0 << 5 | c0 >>> 27;
        m4 = m4 << 22 | m4 >>> 10;
        c1 = c1 << 13 | c1 >>> 19;
        m5 = m5 << 3 | m5 >>> 29;
        c2 ^= c1 ^ m5;
        m6 ^= m5 ^ c1 << 3;
        c2 = c2 << 1 | c2 >>> 31;
        m6 = m6 << 7 | m6 >>> 25;
        c1 ^= c2 ^ m6;
        m5 ^= m6 ^ c2 << 7;
        c1 = c1 << 5 | c1 >>> 27;
        m5 = m5 << 22 | m5 >>> 10;
        m0 ^= ALPHA_N[0];
        m1 ^= ALPHA_N[1] ^ 1;
        c0 ^= ALPHA_N[2];
        c1 ^= ALPHA_N[3];
        c2 ^= ALPHA_N[8];
        c3 ^= ALPHA_N[9];
        m2 ^= ALPHA_N[10];
        m3 ^= ALPHA_N[11];
        m4 ^= ALPHA_N[16];
        m5 ^= ALPHA_N[17];
        c4 ^= ALPHA_N[18];
        c5 ^= ALPHA_N[19];
        c6 ^= ALPHA_N[24];
        c7 ^= ALPHA_N[25];
        m6 ^= ALPHA_N[26];
        m7 ^= ALPHA_N[27];
        t = m0;
        m0 &= m4;
        m4 ^= c2;
        m4 ^= (m0 ^= c6);
        c6 |= t;
        c6 ^= c2;
        c2 = c6;
        c6 |= (t ^= m4);
        c6 ^= m0;
        t ^= (m0 &= c2);
        c2 ^= c6;
        m0 = m4;
        m4 = c2 ^= t;
        c2 = c6;
        c6 = ~t;
        t = m1;
        m1 &= m5;
        m5 ^= c3;
        m5 ^= (m1 ^= c7);
        c7 |= t;
        c7 ^= c3;
        c3 = c7;
        c7 |= (t ^= m5);
        c7 ^= m1;
        t ^= (m1 &= c3);
        c3 ^= c7;
        m1 = m5;
        m5 = c3 ^= t;
        c3 = c7;
        c7 = ~t;
        t = c0;
        c0 &= c4;
        c4 ^= m2;
        c4 ^= (c0 ^= m6);
        m6 |= t;
        m6 ^= m2;
        m2 = m6;
        m6 |= (t ^= c4);
        m6 ^= c0;
        t ^= (c0 &= m2);
        m2 ^= m6;
        c0 = c4;
        c4 = m2 ^= t;
        m2 = m6;
        m6 = ~t;
        t = c1;
        c1 &= c5;
        c5 ^= m3;
        c5 ^= (c1 ^= m7);
        m7 |= t;
        m7 ^= m3;
        m3 = m7;
        m7 |= (t ^= c5);
        m7 ^= c1;
        t ^= (c1 &= m3);
        m3 ^= m7;
        c1 = c5;
        c5 = m3 ^= t;
        m3 = m7;
        m7 = ~t;
        m0 = m0 << 13 | m0 >>> 19;
        c4 = c4 << 3 | c4 >>> 29;
        c3 ^= m0 ^ c4;
        m7 ^= c4 ^ m0 << 3;
        c3 = c3 << 1 | c3 >>> 31;
        m7 = m7 << 7 | m7 >>> 25;
        m0 ^= c3 ^ m7;
        c4 ^= m7 ^ c3 << 7;
        m0 = m0 << 5 | m0 >>> 27;
        c4 = c4 << 22 | c4 >>> 10;
        m1 = m1 << 13 | m1 >>> 19;
        c5 = c5 << 3 | c5 >>> 29;
        m2 ^= m1 ^ c5;
        c6 ^= c5 ^ m1 << 3;
        m2 = m2 << 1 | m2 >>> 31;
        c6 = c6 << 7 | c6 >>> 25;
        m1 ^= m2 ^ c6;
        c5 ^= c6 ^ m2 << 7;
        m1 = m1 << 5 | m1 >>> 27;
        c5 = c5 << 22 | c5 >>> 10;
        c0 = c0 << 13 | c0 >>> 19;
        m4 = m4 << 3 | m4 >>> 29;
        m3 ^= c0 ^ m4;
        c7 ^= m4 ^ c0 << 3;
        m3 = m3 << 1 | m3 >>> 31;
        c7 = c7 << 7 | c7 >>> 25;
        c0 ^= m3 ^ c7;
        m4 ^= c7 ^ m3 << 7;
        c0 = c0 << 5 | c0 >>> 27;
        m4 = m4 << 22 | m4 >>> 10;
        c1 = c1 << 13 | c1 >>> 19;
        m5 = m5 << 3 | m5 >>> 29;
        c2 ^= c1 ^ m5;
        m6 ^= m5 ^ c1 << 3;
        c2 = c2 << 1 | c2 >>> 31;
        m6 = m6 << 7 | m6 >>> 25;
        c1 ^= c2 ^ m6;
        m5 ^= m6 ^ c2 << 7;
        c1 = c1 << 5 | c1 >>> 27;
        m5 = m5 << 22 | m5 >>> 10;
        m0 ^= ALPHA_N[0];
        m1 ^= ALPHA_N[1] ^ 2;
        c0 ^= ALPHA_N[2];
        c1 ^= ALPHA_N[3];
        c2 ^= ALPHA_N[8];
        c3 ^= ALPHA_N[9];
        m2 ^= ALPHA_N[10];
        m3 ^= ALPHA_N[11];
        m4 ^= ALPHA_N[16];
        m5 ^= ALPHA_N[17];
        c4 ^= ALPHA_N[18];
        c5 ^= ALPHA_N[19];
        c6 ^= ALPHA_N[24];
        c7 ^= ALPHA_N[25];
        m6 ^= ALPHA_N[26];
        m7 ^= ALPHA_N[27];
        t = m0;
        m0 &= m4;
        m4 ^= c2;
        m4 ^= (m0 ^= c6);
        c6 |= t;
        c6 ^= c2;
        c2 = c6;
        c6 |= (t ^= m4);
        c6 ^= m0;
        t ^= (m0 &= c2);
        c2 ^= c6;
        m0 = m4;
        m4 = c2 ^= t;
        c2 = c6;
        c6 = ~t;
        t = m1;
        m1 &= m5;
        m5 ^= c3;
        m5 ^= (m1 ^= c7);
        c7 |= t;
        c7 ^= c3;
        c3 = c7;
        c7 |= (t ^= m5);
        c7 ^= m1;
        t ^= (m1 &= c3);
        c3 ^= c7;
        m1 = m5;
        m5 = c3 ^= t;
        c3 = c7;
        c7 = ~t;
        t = c0;
        c0 &= c4;
        c4 ^= m2;
        c4 ^= (c0 ^= m6);
        m6 |= t;
        m6 ^= m2;
        m2 = m6;
        m6 |= (t ^= c4);
        m6 ^= c0;
        t ^= (c0 &= m2);
        m2 ^= m6;
        c0 = c4;
        c4 = m2 ^= t;
        m2 = m6;
        m6 = ~t;
        t = c1;
        c1 &= c5;
        c5 ^= m3;
        c5 ^= (c1 ^= m7);
        m7 |= t;
        m7 ^= m3;
        m3 = m7;
        m7 |= (t ^= c5);
        m7 ^= c1;
        t ^= (c1 &= m3);
        m3 ^= m7;
        c1 = c5;
        c5 = m3 ^= t;
        m3 = m7;
        m7 = ~t;
        m0 = m0 << 13 | m0 >>> 19;
        c4 = c4 << 3 | c4 >>> 29;
        c3 ^= m0 ^ c4;
        m7 ^= c4 ^ m0 << 3;
        c3 = c3 << 1 | c3 >>> 31;
        m7 = m7 << 7 | m7 >>> 25;
        m0 ^= c3 ^ m7;
        c4 ^= m7 ^ c3 << 7;
        m0 = m0 << 5 | m0 >>> 27;
        c4 = c4 << 22 | c4 >>> 10;
        m1 = m1 << 13 | m1 >>> 19;
        c5 = c5 << 3 | c5 >>> 29;
        m2 ^= m1 ^ c5;
        c6 ^= c5 ^ m1 << 3;
        m2 = m2 << 1 | m2 >>> 31;
        c6 = c6 << 7 | c6 >>> 25;
        m1 ^= m2 ^ c6;
        c5 ^= c6 ^ m2 << 7;
        m1 = m1 << 5 | m1 >>> 27;
        c5 = c5 << 22 | c5 >>> 10;
        c0 = c0 << 13 | c0 >>> 19;
        m4 = m4 << 3 | m4 >>> 29;
        m3 ^= c0 ^ m4;
        c7 ^= m4 ^ c0 << 3;
        m3 = m3 << 1 | m3 >>> 31;
        c7 = c7 << 7 | c7 >>> 25;
        c0 ^= m3 ^ c7;
        m4 ^= c7 ^ m3 << 7;
        c0 = c0 << 5 | c0 >>> 27;
        m4 = m4 << 22 | m4 >>> 10;
        c1 = c1 << 13 | c1 >>> 19;
        m5 = m5 << 3 | m5 >>> 29;
        c2 ^= c1 ^ m5;
        m6 ^= m5 ^ c1 << 3;
        c2 = c2 << 1 | c2 >>> 31;
        m6 = m6 << 7 | m6 >>> 25;
        c1 ^= c2 ^ m6;
        m5 ^= m6 ^ c2 << 7;
        c1 = c1 << 5 | c1 >>> 27;
        m5 = m5 << 22 | m5 >>> 10;
        this.h[7] = this.h[7] ^ c5;
        this.h[6] = this.h[6] ^ c4;
        this.h[5] = this.h[5] ^ m5;
        this.h[4] = this.h[4] ^ m4;
        this.h[3] = this.h[3] ^ c1;
        this.h[2] = this.h[2] ^ c0;
        this.h[1] = this.h[1] ^ m1;
        this.h[0] = this.h[0] ^ m0;
    }

    private void processFinal(int b0, int b1, int b2, int b3) {
        int[] rp = T256_0[b0];
        int m0 = rp[0];
        int m1 = rp[1];
        int m2 = rp[2];
        int m3 = rp[3];
        int m4 = rp[4];
        int m5 = rp[5];
        int m6 = rp[6];
        int m7 = rp[7];
        rp = T256_1[b1];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        rp = T256_2[b2];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        rp = T256_3[b3];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        int c0 = this.h[0];
        int c1 = this.h[1];
        int c2 = this.h[2];
        int c3 = this.h[3];
        int c4 = this.h[4];
        int c5 = this.h[5];
        int c6 = this.h[6];
        int c7 = this.h[7];
        for (int r = 0; r < 6; ++r) {
            m0 ^= ALPHA_F[0];
            m1 ^= ALPHA_F[1] ^ r;
            c0 ^= ALPHA_F[2];
            c1 ^= ALPHA_F[3];
            c2 ^= ALPHA_F[8];
            c3 ^= ALPHA_F[9];
            m2 ^= ALPHA_F[10];
            m3 ^= ALPHA_F[11];
            m4 ^= ALPHA_F[16];
            m5 ^= ALPHA_F[17];
            c4 ^= ALPHA_F[18];
            c5 ^= ALPHA_F[19];
            c6 ^= ALPHA_F[24];
            c7 ^= ALPHA_F[25];
            m6 ^= ALPHA_F[26];
            m7 ^= ALPHA_F[27];
            int t = m0;
            m0 &= m4;
            m4 ^= c2;
            m4 ^= (m0 ^= c6);
            c6 |= t;
            c6 ^= c2;
            c2 = c6;
            c6 |= (t ^= m4);
            c6 ^= m0;
            t ^= (m0 &= c2);
            c2 ^= c6;
            m0 = m4;
            m4 = c2 ^= t;
            c2 = c6;
            c6 = ~t;
            t = m1;
            m1 &= m5;
            m5 ^= c3;
            m5 ^= (m1 ^= c7);
            c7 |= t;
            c7 ^= c3;
            c3 = c7;
            c7 |= (t ^= m5);
            c7 ^= m1;
            t ^= (m1 &= c3);
            c3 ^= c7;
            m1 = m5;
            m5 = c3 ^= t;
            c3 = c7;
            c7 = ~t;
            t = c0;
            c0 &= c4;
            c4 ^= m2;
            c4 ^= (c0 ^= m6);
            m6 |= t;
            m6 ^= m2;
            m2 = m6;
            m6 |= (t ^= c4);
            m6 ^= c0;
            t ^= (c0 &= m2);
            m2 ^= m6;
            c0 = c4;
            c4 = m2 ^= t;
            m2 = m6;
            m6 = ~t;
            t = c1;
            c1 &= c5;
            c5 ^= m3;
            c5 ^= (c1 ^= m7);
            m7 |= t;
            m7 ^= m3;
            m3 = m7;
            m7 |= (t ^= c5);
            m7 ^= c1;
            t ^= (c1 &= m3);
            m3 ^= m7;
            c1 = c5;
            c5 = m3 ^= t;
            m3 = m7;
            m7 = ~t;
            m0 = m0 << 13 | m0 >>> 19;
            c4 = c4 << 3 | c4 >>> 29;
            c3 ^= m0 ^ c4;
            m7 ^= c4 ^ m0 << 3;
            c3 = c3 << 1 | c3 >>> 31;
            m7 = m7 << 7 | m7 >>> 25;
            m0 ^= c3 ^ m7;
            c4 ^= m7 ^ c3 << 7;
            m0 = m0 << 5 | m0 >>> 27;
            c4 = c4 << 22 | c4 >>> 10;
            m1 = m1 << 13 | m1 >>> 19;
            c5 = c5 << 3 | c5 >>> 29;
            m2 ^= m1 ^ c5;
            c6 ^= c5 ^ m1 << 3;
            m2 = m2 << 1 | m2 >>> 31;
            c6 = c6 << 7 | c6 >>> 25;
            m1 ^= m2 ^ c6;
            c5 ^= c6 ^ m2 << 7;
            m1 = m1 << 5 | m1 >>> 27;
            c5 = c5 << 22 | c5 >>> 10;
            c0 = c0 << 13 | c0 >>> 19;
            m4 = m4 << 3 | m4 >>> 29;
            m3 ^= c0 ^ m4;
            c7 ^= m4 ^ c0 << 3;
            m3 = m3 << 1 | m3 >>> 31;
            c7 = c7 << 7 | c7 >>> 25;
            c0 ^= m3 ^ c7;
            m4 ^= c7 ^ m3 << 7;
            c0 = c0 << 5 | c0 >>> 27;
            m4 = m4 << 22 | m4 >>> 10;
            c1 = c1 << 13 | c1 >>> 19;
            m5 = m5 << 3 | m5 >>> 29;
            c2 ^= c1 ^ m5;
            m6 ^= m5 ^ c1 << 3;
            c2 = c2 << 1 | c2 >>> 31;
            m6 = m6 << 7 | m6 >>> 25;
            c1 ^= c2 ^ m6;
            m5 ^= m6 ^ c2 << 7;
            c1 = c1 << 5 | c1 >>> 27;
            m5 = m5 << 22 | m5 >>> 10;
        }
        this.h[7] = this.h[7] ^ c5;
        this.h[6] = this.h[6] ^ c4;
        this.h[5] = this.h[5] ^ m5;
        this.h[4] = this.h[4] ^ m4;
        this.h[3] = this.h[3] ^ c1;
        this.h[2] = this.h[2] ^ c0;
        this.h[1] = this.h[1] ^ m1;
        this.h[0] = this.h[0] ^ m0;
    }

    @Override
    public String toString() {
        return "Hamsi-" + (this.getDigestLength() << 3);
    }
}

