/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;

abstract class HamsiBigCore
implements Digest {
    private int[] h = new int[16];
    private long bitCount;
    private long partial;
    private int partialLen;
    private static final int[] HOFF384 = new int[]{0, 1, 3, 4, 5, 6, 8, 9, 10, 12, 13, 15};
    private static final int[] HOFF512 = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[][] Tsrc = new int[][]{{1181551616, 140640256, -581107712, -1159921664, 1787984194, 1142893459, 562744943, -1087632414, 1864994816, 1820655616, 789970944, 2016280576, 1682716621, 316480726, -764769226, 841061670}, {692362240, 1692860416, -229965824, -1024262144, 249450127, 1455568709, -203406759, -1928487228, 1181551616, 140640256, -581107712, -1159921664, 1787984194, 1142893459, 562744943, -1087632414}, {-1665460224, -1328349184, -1840185344, -309133312, 1496990533, -518728204, 1124479962, 2026556969, -929872896, 1514012672, 1468465152, 1280704512, -359128011, 1974538517, 683045447, 768735659}, {1411931136, -353566720, -975831040, -1580924928, -1281202320, -1801075487, 1806713245, 1427847042, -1665460224, -1328349184, -1840185344, -309133312, 1496990533, -518728204, 1124479962, 2026556969}, {593957888, -927399936, -188284928, -76218368, 1942824037, -123296439, 46402111, -601561569, 926754816, 1901068288, -1780482048, 169082880, -1112794871, 1223661617, 1164799263, 1034601178}, {341457920, -1175912448, 1629945856, -245301248, -832488084, -1337377416, 1202284320, -510778171, 593957888, -927399936, -188284928, -76218368, 1942824037, -123296439, 46402111, -601561569}, {-915734480, -417005568, 797179904, 642711552, 141122553, 1845293367, 1352624516, -1637240984, 643826240, -573046784, 1915355136, 1325793280, -1822005249, 704201934, 915104725, 203879010}, {-284491152, 989659136, 1571684352, 1766391808, -1693500410, 1141224953, 1712589393, -1840292598, -915734480, -417005568, 797179904, 642711552, 141122553, 1845293367, 1352624516, -1637240984}, {-1271463840, 0xC4C0000, 1455554560, 1554907136, -1806426305, 993982501, 456548157, -204187816, 1555038480, -1858207744, 1142489088, -2004090880, 1725723672, -1843454618, 1439623717, -1839446807}, {-393805456, -1653473280, 316342272, -735969280, -225940697, -1457396413, 1324922136, 1636307889, -1271463840, 0xC4C0000, 1455554560, 1554907136, -1806426305, 993982501, 456548157, -204187816}, {-194248624, -1776812032, 346357760, 52363264, 1117028024, 1723825689, -1666944814, -1976298124, -2094530400, 1732378624, -518586368, 923467776, -878510028, 1010078268, -1754808884, 1157849279}, {2000945392, -245760000, -172883968, 873725952, -1992851828, 1519119397, 197381406, -818448949, -194248624, -1776812032, 346357760, 52363264, 1117028024, 1723825689, -1666944814, -1976298124}, {-731250688, -1916223488, -1515257856, 1244200960, -61980038, -910915988, -1741253116, -146357472, 589234185, 1123287040, 1719205888, 1320878080, -19178541, 828158166, -491690166, 1766873914}, {-143327223, -818102272, -1009385472, 76677120, 43325865, -118999366, 2055729486, -1642686438, -731250688, -1916223488, -1515257856, 1244200960, -61980038, -910915988, -1741253116, -146357472}, {-1501626367, 1899462656, 435945472, -1764032512, 982216189, -339038477, 745359247, -1399952248, 1358888964, 1165246464, 1039859712, 434503680, 465327622, -512591011, -509031274, 2065422009}, {-159383547, 876855296, 604438528, -1891827712, 557267963, 179885486, -842691815, -678053327, -1501626367, 1899462656, 435945472, -1764032512, 982216189, -339038477, 745359247, -1399952248}, {-288423935, 1867923456, -214040576, -1482817536, -1112182247, -1223562299, 1245397178, -22285740, -1694105598, 1632010240, 572391424, 494141440, 913399079, 810114194, -250399065, -31662977}, {1976107011, 235978752, -786432000, -1159069696, -1950077122, -2024229033, -1154976227, 12004907, -288423935, 1867923456, -214040576, -1482817536, -1112182247, -1223562299, 1245397178, -22285740}, {-781844480, 465306368, -1628700672, -158072832, 50480423, -814678798, -1270670569, -2055259093, -1530789888, -650697728, 172490752, 0x66610000, -126217529, -2034305188, -1557864556, 731929173}, {1973682176, -1031067904, -1801191424, -1862991872, -75999264, 1238240174, 392676483, -1361090946, -781844480, 465306368, -1628700672, -158072832, 50480423, -814678798, -1270670569, -2055259093}, {-1203961856, 376505856, 932839424, -172949504, 578904492, -1370951355, 1713640982, -977147074, -47906816, -1278996224, -823132160, -822542336, 1011709312, -1923390317, 1889054886, 452075489}, {1159200768, -1514858752, -110493696, 994574336, 516690988, 588486102, 381462192, -550243105, -1203961856, 376505856, 932839424, -172949504, 578904492, -1370951355, 1713640982, -977147074}, {-31326208, -1487403776, 634454016, -144703488, -1993246502, 534050912, 1322296085, -1591476321, -229638144, -289601024, 1739063296, -1417019392, -1164228416, 173464948, -613160850, 359202575}, {208797696, 1239748352, 1115226112, 1558839296, 866791450, 360850708, -1784460421, -1270153072, -31326208, -1487403776, 634454016, -144703488, -1993246502, 534050912, 1322296085, -1591476321}, {-965541888, -1349713908, -1530855424, 562888704, 588322183, 2031309103, 489204872, 932041075, -1356726272, 2070675600, 1742864384, -1918763008, -947642839, -1212726029, -1698396940, -1955827011}, {1766916096, -723451748, -1021116416, -1406205952, -459994194, -828107300, -2014566276, -1126063154, -965541888, -1349713908, -1530855424, 562888704, 588322183, 2031309103, 489204872, 932041075}, {-1131610112, -63242216, 428015616, -787808256, -1374127932, 1118214230, 1235511, 742084686, -388169728, -95813564, 1009582080, -1156251648, -2135083493, 619191620, -1079459084, 1380584793}, {0x54500000, 108068956, 632160256, 1780350976, 782585567, 1716421906, -1078323005, 2121358615, -1131610112, -63242216, 428015616, -787808256, -1374127932, 1118214230, 1235511, 742084686}, {-482148352, 978190356, -221904896, -1437728768, -618773850, 627818005, 306032982, 978229719, -145096704, 428081192, -1575419904, -285736960, -1066261226, 429396576, 1943773670, -511425961}, {337182720, 600440892, 1356791808, 1152778240, 460089264, 1022602357, 1642467504, -607462528, -482148352, 978190356, -221904896, -1437728768, -618773850, 627818005, 306032982, 978229719}, {817299456, -439353344, -185311232, 1120141312, 1673018730, 2025493600, 565158378, -1331357644, -1228013568, -622264318, 359563264, -627965952, -153265564, 909270154, -227350354, -1497841011}, {-2038890496, 1060700162, -509943808, -1739194368, -1788516594, 1317587178, -740472508, 371055289, 817299456, -439353344, -185311232, 1120141312, 1673018730, 2025493600, 565158378, -1331357644}, {-618332160, 0x9290000, 1235927040, -2115960832, -889296039, 1115239473, 1129737078, -395527634, 1978007552, -1788477439, 813375488, -1376518144, -1892540694, 606700295, -389767943, 1266609237}, {-1362952192, -1672544255, 2043797504, 739573760, 1171027379, 1716565814, -1416431729, -1559079301, -618332160, 0x9290000, 1235927040, -2115960832, -889296039, 1115239473, 1129737078, -395527634}, {508428288, -556859392, 1844969856, 1998848000, -330889314, -190813874, -844949486, -1733670546, -1308229632, -982974464, 671289856, 1952907264, -1228785932, -351127048, 869392364, 156119448}, {-1404567552, 463863808, 1174082432, 0x3430000, 1518678378, 531779766, -26032130, -1847297802, 508428288, -556859392, 1844969856, 1998848000, -330889314, -190813874, -844949486, -1733670546}, {45023232, -1222115328, -1172569344, 1452802048, -1165146669, -2142714265, -1453583206, -185144709, 2055995392, -1512833024, 321259648, -969080832, -877433430, -22982845, 1506850040, -1751555632}, {2015559680, 318504960, -1455813760, -1868234752, 1899899001, 2129234212, -259219358, 1668254635, 45023232, -1222115328, -1172569344, 1452802048, -1165146669, -2142714265, -1453583206, -185144709}, {-2120351744, -329842688, 1714553472, -1779236864, 1571366914, 1223965884, -430267859, -1905805318, 1300889600, 1228144640, 1015743744, -1365049344, 377043965, -814806876, -1894126868, 1144860676}, {-871104512, -1520238592, 1522075520, 995098624, 1271927807, -2019871720, 1766017217, -900036610, -2120351744, -329842688, 1714553472, -1779236864, 1571366914, 1223965884, -430267859, -1905805318}, {1401749504, -1443102720, -1627979770, 1459552256, 182714446, -1832530439, -1455144936, 2140624529, 0x1DD0000, -2136473600, -191496120, -1509949440, -1865056606, -672756681, 1712508925, 747914654}, {0x52500000, 693370880, 1784741966, -251723776, -1708032276, 1159938510, -816410651, 1392710415, 1401749504, -1443102720, -1627979770, 1459552256, 182714446, -1832530439, -1455144936, 2140624529}, {197263360, -614268928, 2122842124, 361103360, -1845671693, 1971436355, -195017570, -659155869, -2091253760, -990445568, 21430306, -288882688, 1621446505, 338635300, 1559573746, 1051091191}, {-2003304448, 529793024, 2144272430, -78774272, -245889126, 1638830439, -1466601364, -435129196, 197263360, -614268928, 2122842124, 361103360, -1845671693, 1971436355, -195017570, -659155869}, {132972544, -1303379968, -2022440950, -1760755712, 1131553710, 1221029540, -193437150, -1871334962, -1563033600, -1502216192, -918290412, -341639168, -856936837, 806929561, 55118586, -1687226232}, {-1522860032, 338034688, 1311768606, 2091778048, -1885467179, 2027924029, -147756840, 186337606, 132972544, -1303379968, -2022440950, -1760755712, 1131553710, 1221029540, -193437150, -1871334962}, {492437504, 728891392, 1217200128, -1352591360, 634072773, -931545136, -2120088535, 510998182, 1159266304, -1425276928, 817758209, 1762271232, -1023643111, -1311473651, 768735814, 607211287}, {1480785920, -2139226112, 2016608257, -966051840, -415802148, 2041397213, -1401684369, 977566129, 492437504, 728891392, 1217200128, -1352591360, 634072773, -931545136, -2120088535, 510998182}, {-1839857664, 517603328, -363790336, -391041024, -1456122203, -335847015, -1319361964, 868557903, -1942355968, -627572736, 1618935808, 1409779712, -2056174317, 1611051587, -615499364, -1973885276}, {510394368, -1002307584, -1976696832, -1128876032, 742658998, -1946299430, 1779178440, -1180843285, -1839857664, 517603328, -363790336, -391041024, -1456122203, -335847015, -1319361964, 868557903}, {-1159921664, 330104832, -1209597952, -148363264, -549120947, 907723578, -363164396, 707533040, -1204879360, -1322516480, 819462144, 340021248, -1051172702, 824699116, 781762339, 1428045166}, {0x2F20000, -1568604160, -2025914368, -479430656, 505246959, 121449430, -993906121, 2133992862, -1159921664, 330104832, -1209597952, -148363264, -549120947, 907723578, -363164396, 707533040}, {-486146048, -1111425024, -2028797952, -1074659232, 783944218, -1917503663, 1942334214, 1540756793, 1463222272, -890109952, 911081472, -1071512448, 1444440866, 1554248716, -1584169073, 364470759}, {-1271857152, 0x77330000, -1319305216, 2144339168, 2023907640, -787037347, -766061431, 1315927262, -486146048, -1111425024, -2028797952, -1074659232, 783944218, -1917503663, 1942334214, 1540756793}, {-255524864, 1495465984, 1166147584, -510852928, 997000753, -1024633191, -874447332, 1453830559, 384630784, 359137280, -304676864, 844956192, -485738871, 1514858051, -478807896, -2114062072}, {-433586176, 1279983616, -1470824448, -741342496, -664719176, -1733840678, 680855220, -681949033, -255524864, 1495465984, 1166147584, -510852928, 997000753, -1024633191, -874447332, 1453830559}, {2066219008, 1463943168, -1444610048, 1665335456, -1629797329, 1838781883, 670579459, -939564816, -1782906880, -2126184448, 992215040, 1222312256, 176843859, 1458925292, 1657346167, -404747628}, {-292356096, -704184320, -1832845312, 731382240, -1806620548, 996997975, 1160848244, 538929764, 2066219008, 1463943168, -1444610048, 1665335456, -1629797329, 1838781883, 670579459, -939564816}, {0x440000, 2135425024, -629407744, 706936833, 1001245132, -1447650169, 51027552, -1106614370, 1609302016, 692781056, -1714290688, 1322254354, 517164915, -1163458359, 1460931551, 816758007}, {1604845568, 1443037184, 1135476736, 1693646867, 629049023, 319919182, 1411290559, -1901798551, 0x440000, 2135425024, -629407744, 706936833, 1001245132, -1447650169, 51027552, -1106614370}, {-1842872320, -595263488, 1476001792, 1457258499, -1159126250, 1525654284, -1865484462, 2065069527, -1816461312, 990314496, -1174339584, -1714421752, 926527054, -431220958, -1762093389, 679078828}, {26411008, -410910720, -302317568, -821297141, -1915712168, -1130122194, 104227297, 1399823995, -1842872320, -595263488, 1476001792, 1457258499, -1159126250, 1525654284, -1865484462, 2065069527}, {-1462108160, -1765933056, 1545404416, 131727362, 2103874947, 530083978, -1150908408, -628654080, -1410924544, -1643315200, -1356398592, 1024983045, 743382995, 1962284693, -1245493269, 1012793342}, {0x33D0000, 145948672, -214302720, 985792519, 1361676880, 1802397215, 245747683, -421888002, -1462108160, -1765933056, 1545404416, 131727362, 2103874947, 530083978, -1150908408, -628654080}};
    private static final int[][] T512_0 = HamsiBigCore.makeT(0);
    private static final int[][] T512_1 = HamsiBigCore.makeT(8);
    private static final int[][] T512_2 = HamsiBigCore.makeT(16);
    private static final int[][] T512_3 = HamsiBigCore.makeT(24);
    private static final int[][] T512_4 = HamsiBigCore.makeT(32);
    private static final int[][] T512_5 = HamsiBigCore.makeT(40);
    private static final int[][] T512_6 = HamsiBigCore.makeT(48);
    private static final int[][] T512_7 = HamsiBigCore.makeT(56);
    private static final int[] ALPHA_N = new int[]{-16715536, -859002198, -252654388, -16733526, -859002198, -252641536, -1431647028, -252641536, -252654388, -1431634176, -858980608, -1431637776, -1431637776, -16724788, -858984208, -16733526, -859002198, -16715536, -16733526, -252654388, -252641536, -859002198, -252641536, -1431647028, -1431634176, -252654388, -1431637776, -858980608, -16724788, -1431637776, -16733526, -858984208};
    private static final int[] ALPHA_F = new int[]{-889625700, 267450816, 1671172080, -889587264, 267450816, 1671219961, -104853520, 1671219961, 1671172080, -104805639, 267438841, -104832100, -104832100, -889647120, 267412380, -889587264, 267450816, -889625700, -889587264, 1671172080, 1671219961, 267450816, 1671219961, -104853520, -104805639, 1671172080, -104832100, 267438841, -889647120, -104832100, -889587264, 267412380};

    HamsiBigCore() {
        this.reset();
    }

    @Override
    public void update(byte in) {
        this.bitCount += 8L;
        this.partial = this.partial << 8 | (long)(in & 0xFF);
        ++this.partialLen;
        if (this.partialLen == 8) {
            this.process((int)(this.partial >>> 56) & 0xFF, (int)(this.partial >>> 48) & 0xFF, (int)(this.partial >>> 40) & 0xFF, (int)(this.partial >>> 32) & 0xFF, (int)this.partial >>> 24 & 0xFF, (int)this.partial >>> 16 & 0xFF, (int)this.partial >>> 8 & 0xFF, (int)this.partial & 0xFF);
            this.partialLen = 0;
        }
    }

    @Override
    public void update(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
    }

    @Override
    public void update(byte[] inbuf, int off, int len) {
        this.bitCount += (long)len << 3;
        if (this.partialLen != 0) {
            while (this.partialLen < 8 && len > 0) {
                this.partial = this.partial << 8 | (long)(inbuf[off++] & 0xFF);
                ++this.partialLen;
                --len;
            }
            if (this.partialLen < 8) {
                return;
            }
            this.process((int)(this.partial >>> 56) & 0xFF, (int)(this.partial >>> 48) & 0xFF, (int)(this.partial >>> 40) & 0xFF, (int)(this.partial >>> 32) & 0xFF, (int)this.partial >>> 24 & 0xFF, (int)this.partial >>> 16 & 0xFF, (int)this.partial >>> 8 & 0xFF, (int)this.partial & 0xFF);
            this.partialLen = 0;
        }
        while (len >= 8) {
            this.process(inbuf[off + 0] & 0xFF, inbuf[off + 1] & 0xFF, inbuf[off + 2] & 0xFF, inbuf[off + 3] & 0xFF, inbuf[off + 4] & 0xFF, inbuf[off + 5] & 0xFF, inbuf[off + 6] & 0xFF, inbuf[off + 7] & 0xFF);
            off += 8;
            len -= 8;
        }
        this.partialLen = len;
        while (len-- > 0) {
            this.partial = this.partial << 8 | (long)(inbuf[off++] & 0xFF);
        }
    }

    @Override
    public byte[] digest() {
        int n = this.getDigestLength();
        byte[] out = new byte[n];
        this.digest(out, 0, n);
        return out;
    }

    @Override
    public byte[] digest(byte[] inbuf) {
        this.update(inbuf, 0, inbuf.length);
        return this.digest();
    }

    @Override
    public int digest(byte[] outbuf, int off, int len) {
        long bitCount = this.bitCount;
        this.update((byte)-128);
        while (this.partialLen != 0) {
            this.update((byte)0);
        }
        this.processFinal((int)(bitCount >>> 56) & 0xFF, (int)(bitCount >>> 48) & 0xFF, (int)(bitCount >>> 40) & 0xFF, (int)(bitCount >>> 32) & 0xFF, (int)bitCount >>> 24 & 0xFF, (int)bitCount >>> 16 & 0xFF, (int)bitCount >>> 8 & 0xFF, (int)bitCount & 0xFF);
        int n = this.getDigestLength();
        if (len > n) {
            len = n;
        }
        int ch = 0;
        int[] hoff = n == 48 ? HOFF384 : HOFF512;
        int j = 0;
        for (int i = 0; i < len; ++i) {
            if ((i & 3) == 0) {
                ch = this.h[hoff[j++]];
            }
            outbuf[off + i] = (byte)(ch >>> 24);
            ch <<= 8;
        }
        this.reset();
        return len;
    }

    @Override
    public void reset() {
        System.arraycopy(this.getIV(), 0, this.h, 0, this.h.length);
        this.bitCount = 0L;
        this.partialLen = 0;
    }

    @Override
    public Digest copy() {
        HamsiBigCore d = this.dup();
        System.arraycopy(this.h, 0, d.h, 0, this.h.length);
        d.bitCount = this.bitCount;
        d.partial = this.partial;
        d.partialLen = this.partialLen;
        return d;
    }

    @Override
    public int getBlockLength() {
        return -32;
    }

    abstract int[] getIV();

    abstract HamsiBigCore dup();

    private static int[][] makeT(int x) {
        int[][] T = new int[256][16];
        for (int y = 0; y < 256; ++y) {
            for (int z = 0; z < 16; ++z) {
                int a = 0;
                for (int k = 0; k < 8; ++k) {
                    if ((y & 1 << 7 - k) == 0) continue;
                    a ^= Tsrc[x + k][z];
                }
                T[y][z] = a;
            }
        }
        return T;
    }

    private void process(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7) {
        int[] rp = T512_0[b0];
        int m0 = rp[0];
        int m1 = rp[1];
        int m2 = rp[2];
        int m3 = rp[3];
        int m4 = rp[4];
        int m5 = rp[5];
        int m6 = rp[6];
        int m7 = rp[7];
        int m8 = rp[8];
        int m9 = rp[9];
        int mA = rp[10];
        int mB = rp[11];
        int mC = rp[12];
        int mD = rp[13];
        int mE = rp[14];
        int mF = rp[15];
        rp = T512_1[b1];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_2[b2];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_3[b3];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_4[b4];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_5[b5];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_6[b6];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_7[b7];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        int c0 = this.h[0];
        int c1 = this.h[1];
        int c2 = this.h[2];
        int c3 = this.h[3];
        int c4 = this.h[4];
        int c5 = this.h[5];
        int c6 = this.h[6];
        int c7 = this.h[7];
        int c8 = this.h[8];
        int c9 = this.h[9];
        int cA = this.h[10];
        int cB = this.h[11];
        int cC = this.h[12];
        int cD = this.h[13];
        int cE = this.h[14];
        int cF = this.h[15];
        for (int r = 0; r < 6; ++r) {
            m0 ^= ALPHA_N[0];
            m1 ^= ALPHA_N[1] ^ r;
            c0 ^= ALPHA_N[2];
            c1 ^= ALPHA_N[3];
            m2 ^= ALPHA_N[4];
            m3 ^= ALPHA_N[5];
            c2 ^= ALPHA_N[6];
            c3 ^= ALPHA_N[7];
            c4 ^= ALPHA_N[8];
            c5 ^= ALPHA_N[9];
            m4 ^= ALPHA_N[10];
            m5 ^= ALPHA_N[11];
            c6 ^= ALPHA_N[12];
            c7 ^= ALPHA_N[13];
            m6 ^= ALPHA_N[14];
            m7 ^= ALPHA_N[15];
            m8 ^= ALPHA_N[16];
            m9 ^= ALPHA_N[17];
            c8 ^= ALPHA_N[18];
            c9 ^= ALPHA_N[19];
            mA ^= ALPHA_N[20];
            mB ^= ALPHA_N[21];
            cA ^= ALPHA_N[22];
            cB ^= ALPHA_N[23];
            cC ^= ALPHA_N[24];
            cD ^= ALPHA_N[25];
            mC ^= ALPHA_N[26];
            mD ^= ALPHA_N[27];
            cE ^= ALPHA_N[28];
            cF ^= ALPHA_N[29];
            mE ^= ALPHA_N[30];
            mF ^= ALPHA_N[31];
            int t = m0;
            m0 &= m8;
            m8 ^= c4;
            m8 ^= (m0 ^= cC);
            cC |= t;
            cC ^= c4;
            c4 = cC;
            cC |= (t ^= m8);
            cC ^= m0;
            t ^= (m0 &= c4);
            c4 ^= cC;
            m0 = m8;
            m8 = c4 ^= t;
            c4 = cC;
            cC = ~t;
            t = m1;
            m1 &= m9;
            m9 ^= c5;
            m9 ^= (m1 ^= cD);
            cD |= t;
            cD ^= c5;
            c5 = cD;
            cD |= (t ^= m9);
            cD ^= m1;
            t ^= (m1 &= c5);
            c5 ^= cD;
            m1 = m9;
            m9 = c5 ^= t;
            c5 = cD;
            cD = ~t;
            t = c0;
            c0 &= c8;
            c8 ^= m4;
            c8 ^= (c0 ^= mC);
            mC |= t;
            mC ^= m4;
            m4 = mC;
            mC |= (t ^= c8);
            mC ^= c0;
            t ^= (c0 &= m4);
            m4 ^= mC;
            c0 = c8;
            c8 = m4 ^= t;
            m4 = mC;
            mC = ~t;
            t = c1;
            c1 &= c9;
            c9 ^= m5;
            c9 ^= (c1 ^= mD);
            mD |= t;
            mD ^= m5;
            m5 = mD;
            mD |= (t ^= c9);
            mD ^= c1;
            t ^= (c1 &= m5);
            m5 ^= mD;
            c1 = c9;
            c9 = m5 ^= t;
            m5 = mD;
            mD = ~t;
            t = m2;
            m2 &= mA;
            mA ^= c6;
            mA ^= (m2 ^= cE);
            cE |= t;
            cE ^= c6;
            c6 = cE;
            cE |= (t ^= mA);
            cE ^= m2;
            t ^= (m2 &= c6);
            c6 ^= cE;
            m2 = mA;
            mA = c6 ^= t;
            c6 = cE;
            cE = ~t;
            t = m3;
            m3 &= mB;
            mB ^= c7;
            mB ^= (m3 ^= cF);
            cF |= t;
            cF ^= c7;
            c7 = cF;
            cF |= (t ^= mB);
            cF ^= m3;
            t ^= (m3 &= c7);
            c7 ^= cF;
            m3 = mB;
            mB = c7 ^= t;
            c7 = cF;
            cF = ~t;
            t = c2;
            c2 &= cA;
            cA ^= m6;
            cA ^= (c2 ^= mE);
            mE |= t;
            mE ^= m6;
            m6 = mE;
            mE |= (t ^= cA);
            mE ^= c2;
            t ^= (c2 &= m6);
            m6 ^= mE;
            c2 = cA;
            cA = m6 ^= t;
            m6 = mE;
            mE = ~t;
            t = c3;
            c3 &= cB;
            cB ^= m7;
            cB ^= (c3 ^= mF);
            mF |= t;
            mF ^= m7;
            m7 = mF;
            mF |= (t ^= cB);
            mF ^= c3;
            t ^= (c3 &= m7);
            m7 ^= mF;
            c3 = cB;
            cB = m7 ^= t;
            m7 = mF;
            mF = ~t;
            m0 = m0 << 13 | m0 >>> 19;
            c8 = c8 << 3 | c8 >>> 29;
            c5 ^= m0 ^ c8;
            mD ^= c8 ^ m0 << 3;
            c5 = c5 << 1 | c5 >>> 31;
            mD = mD << 7 | mD >>> 25;
            m0 ^= c5 ^ mD;
            c8 ^= mD ^ c5 << 7;
            m0 = m0 << 5 | m0 >>> 27;
            c8 = c8 << 22 | c8 >>> 10;
            m1 = m1 << 13 | m1 >>> 19;
            c9 = c9 << 3 | c9 >>> 29;
            m4 ^= m1 ^ c9;
            cE ^= c9 ^ m1 << 3;
            m4 = m4 << 1 | m4 >>> 31;
            cE = cE << 7 | cE >>> 25;
            m1 ^= m4 ^ cE;
            c9 ^= cE ^ m4 << 7;
            m1 = m1 << 5 | m1 >>> 27;
            c9 = c9 << 22 | c9 >>> 10;
            c0 = c0 << 13 | c0 >>> 19;
            mA = mA << 3 | mA >>> 29;
            m5 ^= c0 ^ mA;
            cF ^= mA ^ c0 << 3;
            m5 = m5 << 1 | m5 >>> 31;
            cF = cF << 7 | cF >>> 25;
            c0 ^= m5 ^ cF;
            mA ^= cF ^ m5 << 7;
            c0 = c0 << 5 | c0 >>> 27;
            mA = mA << 22 | mA >>> 10;
            c1 = c1 << 13 | c1 >>> 19;
            mB = mB << 3 | mB >>> 29;
            c6 ^= c1 ^ mB;
            mE ^= mB ^ c1 << 3;
            c6 = c6 << 1 | c6 >>> 31;
            mE = mE << 7 | mE >>> 25;
            c1 ^= c6 ^ mE;
            mB ^= mE ^ c6 << 7;
            c1 = c1 << 5 | c1 >>> 27;
            mB = mB << 22 | mB >>> 10;
            m2 = m2 << 13 | m2 >>> 19;
            cA = cA << 3 | cA >>> 29;
            c7 ^= m2 ^ cA;
            mF ^= cA ^ m2 << 3;
            c7 = c7 << 1 | c7 >>> 31;
            mF = mF << 7 | mF >>> 25;
            m2 ^= c7 ^ mF;
            cA ^= mF ^ c7 << 7;
            m2 = m2 << 5 | m2 >>> 27;
            cA = cA << 22 | cA >>> 10;
            m3 = m3 << 13 | m3 >>> 19;
            cB = cB << 3 | cB >>> 29;
            m6 ^= m3 ^ cB;
            cC ^= cB ^ m3 << 3;
            m6 = m6 << 1 | m6 >>> 31;
            cC = cC << 7 | cC >>> 25;
            m3 ^= m6 ^ cC;
            cB ^= cC ^ m6 << 7;
            m3 = m3 << 5 | m3 >>> 27;
            cB = cB << 22 | cB >>> 10;
            c2 = c2 << 13 | c2 >>> 19;
            m8 = m8 << 3 | m8 >>> 29;
            m7 ^= c2 ^ m8;
            cD ^= m8 ^ c2 << 3;
            m7 = m7 << 1 | m7 >>> 31;
            cD = cD << 7 | cD >>> 25;
            c2 ^= m7 ^ cD;
            m8 ^= cD ^ m7 << 7;
            c2 = c2 << 5 | c2 >>> 27;
            m8 = m8 << 22 | m8 >>> 10;
            c3 = c3 << 13 | c3 >>> 19;
            m9 = m9 << 3 | m9 >>> 29;
            c4 ^= c3 ^ m9;
            mC ^= m9 ^ c3 << 3;
            c4 = c4 << 1 | c4 >>> 31;
            mC = mC << 7 | mC >>> 25;
            c3 ^= c4 ^ mC;
            m9 ^= mC ^ c4 << 7;
            c3 = c3 << 5 | c3 >>> 27;
            m9 = m9 << 22 | m9 >>> 10;
            m0 = m0 << 13 | m0 >>> 19;
            m3 = m3 << 3 | m3 >>> 29;
            c0 ^= m0 ^ m3;
            c3 ^= m3 ^ m0 << 3;
            c0 = c0 << 1 | c0 >>> 31;
            c3 = c3 << 7 | c3 >>> 25;
            m0 ^= c0 ^ c3;
            m3 ^= c3 ^ c0 << 7;
            m0 = m0 << 5 | m0 >>> 27;
            m3 = m3 << 22 | m3 >>> 10;
            m8 = m8 << 13 | m8 >>> 19;
            mB = mB << 3 | mB >>> 29;
            c9 ^= m8 ^ mB;
            cA ^= mB ^ m8 << 3;
            c9 = c9 << 1 | c9 >>> 31;
            cA = cA << 7 | cA >>> 25;
            m8 ^= c9 ^ cA;
            mB ^= cA ^ c9 << 7;
            m8 = m8 << 5 | m8 >>> 27;
            mB = mB << 22 | mB >>> 10;
            c5 = c5 << 13 | c5 >>> 19;
            c6 = c6 << 3 | c6 >>> 29;
            m5 ^= c5 ^ c6;
            m6 ^= c6 ^ c5 << 3;
            m5 = m5 << 1 | m5 >>> 31;
            m6 = m6 << 7 | m6 >>> 25;
            c5 ^= m5 ^ m6;
            c6 ^= m6 ^ m5 << 7;
            c5 = c5 << 5 | c5 >>> 27;
            c6 = c6 << 22 | c6 >>> 10;
            cD = cD << 13 | cD >>> 19;
            cE = cE << 3 | cE >>> 29;
            mC ^= cD ^ cE;
            mF ^= cE ^ cD << 3;
            mC = mC << 1 | mC >>> 31;
            mF = mF << 7 | mF >>> 25;
            cD ^= mC ^ mF;
            cE ^= mF ^ mC << 7;
            cD = cD << 5 | cD >>> 27;
            cE = cE << 22 | cE >>> 10;
        }
        this.h[15] = this.h[15] ^ cB;
        this.h[14] = this.h[14] ^ cA;
        this.h[13] = this.h[13] ^ mB;
        this.h[12] = this.h[12] ^ mA;
        this.h[11] = this.h[11] ^ c9;
        this.h[10] = this.h[10] ^ c8;
        this.h[9] = this.h[9] ^ m9;
        this.h[8] = this.h[8] ^ m8;
        this.h[7] = this.h[7] ^ c3;
        this.h[6] = this.h[6] ^ c2;
        this.h[5] = this.h[5] ^ m3;
        this.h[4] = this.h[4] ^ m2;
        this.h[3] = this.h[3] ^ c1;
        this.h[2] = this.h[2] ^ c0;
        this.h[1] = this.h[1] ^ m1;
        this.h[0] = this.h[0] ^ m0;
    }

    private void processFinal(int b0, int b1, int b2, int b3, int b4, int b5, int b6, int b7) {
        int[] rp = T512_0[b0];
        int m0 = rp[0];
        int m1 = rp[1];
        int m2 = rp[2];
        int m3 = rp[3];
        int m4 = rp[4];
        int m5 = rp[5];
        int m6 = rp[6];
        int m7 = rp[7];
        int m8 = rp[8];
        int m9 = rp[9];
        int mA = rp[10];
        int mB = rp[11];
        int mC = rp[12];
        int mD = rp[13];
        int mE = rp[14];
        int mF = rp[15];
        rp = T512_1[b1];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_2[b2];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_3[b3];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_4[b4];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_5[b5];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_6[b6];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        rp = T512_7[b7];
        m0 ^= rp[0];
        m1 ^= rp[1];
        m2 ^= rp[2];
        m3 ^= rp[3];
        m4 ^= rp[4];
        m5 ^= rp[5];
        m6 ^= rp[6];
        m7 ^= rp[7];
        m8 ^= rp[8];
        m9 ^= rp[9];
        mA ^= rp[10];
        mB ^= rp[11];
        mC ^= rp[12];
        mD ^= rp[13];
        mE ^= rp[14];
        mF ^= rp[15];
        int c0 = this.h[0];
        int c1 = this.h[1];
        int c2 = this.h[2];
        int c3 = this.h[3];
        int c4 = this.h[4];
        int c5 = this.h[5];
        int c6 = this.h[6];
        int c7 = this.h[7];
        int c8 = this.h[8];
        int c9 = this.h[9];
        int cA = this.h[10];
        int cB = this.h[11];
        int cC = this.h[12];
        int cD = this.h[13];
        int cE = this.h[14];
        int cF = this.h[15];
        for (int r = 0; r < 12; ++r) {
            m0 ^= ALPHA_F[0];
            m1 ^= ALPHA_F[1] ^ r;
            c0 ^= ALPHA_F[2];
            c1 ^= ALPHA_F[3];
            m2 ^= ALPHA_F[4];
            m3 ^= ALPHA_F[5];
            c2 ^= ALPHA_F[6];
            c3 ^= ALPHA_F[7];
            c4 ^= ALPHA_F[8];
            c5 ^= ALPHA_F[9];
            m4 ^= ALPHA_F[10];
            m5 ^= ALPHA_F[11];
            c6 ^= ALPHA_F[12];
            c7 ^= ALPHA_F[13];
            m6 ^= ALPHA_F[14];
            m7 ^= ALPHA_F[15];
            m8 ^= ALPHA_F[16];
            m9 ^= ALPHA_F[17];
            c8 ^= ALPHA_F[18];
            c9 ^= ALPHA_F[19];
            mA ^= ALPHA_F[20];
            mB ^= ALPHA_F[21];
            cA ^= ALPHA_F[22];
            cB ^= ALPHA_F[23];
            cC ^= ALPHA_F[24];
            cD ^= ALPHA_F[25];
            mC ^= ALPHA_F[26];
            mD ^= ALPHA_F[27];
            cE ^= ALPHA_F[28];
            cF ^= ALPHA_F[29];
            mE ^= ALPHA_F[30];
            mF ^= ALPHA_F[31];
            int t = m0;
            m0 &= m8;
            m8 ^= c4;
            m8 ^= (m0 ^= cC);
            cC |= t;
            cC ^= c4;
            c4 = cC;
            cC |= (t ^= m8);
            cC ^= m0;
            t ^= (m0 &= c4);
            c4 ^= cC;
            m0 = m8;
            m8 = c4 ^= t;
            c4 = cC;
            cC = ~t;
            t = m1;
            m1 &= m9;
            m9 ^= c5;
            m9 ^= (m1 ^= cD);
            cD |= t;
            cD ^= c5;
            c5 = cD;
            cD |= (t ^= m9);
            cD ^= m1;
            t ^= (m1 &= c5);
            c5 ^= cD;
            m1 = m9;
            m9 = c5 ^= t;
            c5 = cD;
            cD = ~t;
            t = c0;
            c0 &= c8;
            c8 ^= m4;
            c8 ^= (c0 ^= mC);
            mC |= t;
            mC ^= m4;
            m4 = mC;
            mC |= (t ^= c8);
            mC ^= c0;
            t ^= (c0 &= m4);
            m4 ^= mC;
            c0 = c8;
            c8 = m4 ^= t;
            m4 = mC;
            mC = ~t;
            t = c1;
            c1 &= c9;
            c9 ^= m5;
            c9 ^= (c1 ^= mD);
            mD |= t;
            mD ^= m5;
            m5 = mD;
            mD |= (t ^= c9);
            mD ^= c1;
            t ^= (c1 &= m5);
            m5 ^= mD;
            c1 = c9;
            c9 = m5 ^= t;
            m5 = mD;
            mD = ~t;
            t = m2;
            m2 &= mA;
            mA ^= c6;
            mA ^= (m2 ^= cE);
            cE |= t;
            cE ^= c6;
            c6 = cE;
            cE |= (t ^= mA);
            cE ^= m2;
            t ^= (m2 &= c6);
            c6 ^= cE;
            m2 = mA;
            mA = c6 ^= t;
            c6 = cE;
            cE = ~t;
            t = m3;
            m3 &= mB;
            mB ^= c7;
            mB ^= (m3 ^= cF);
            cF |= t;
            cF ^= c7;
            c7 = cF;
            cF |= (t ^= mB);
            cF ^= m3;
            t ^= (m3 &= c7);
            c7 ^= cF;
            m3 = mB;
            mB = c7 ^= t;
            c7 = cF;
            cF = ~t;
            t = c2;
            c2 &= cA;
            cA ^= m6;
            cA ^= (c2 ^= mE);
            mE |= t;
            mE ^= m6;
            m6 = mE;
            mE |= (t ^= cA);
            mE ^= c2;
            t ^= (c2 &= m6);
            m6 ^= mE;
            c2 = cA;
            cA = m6 ^= t;
            m6 = mE;
            mE = ~t;
            t = c3;
            c3 &= cB;
            cB ^= m7;
            cB ^= (c3 ^= mF);
            mF |= t;
            mF ^= m7;
            m7 = mF;
            mF |= (t ^= cB);
            mF ^= c3;
            t ^= (c3 &= m7);
            m7 ^= mF;
            c3 = cB;
            cB = m7 ^= t;
            m7 = mF;
            mF = ~t;
            m0 = m0 << 13 | m0 >>> 19;
            c8 = c8 << 3 | c8 >>> 29;
            c5 ^= m0 ^ c8;
            mD ^= c8 ^ m0 << 3;
            c5 = c5 << 1 | c5 >>> 31;
            mD = mD << 7 | mD >>> 25;
            m0 ^= c5 ^ mD;
            c8 ^= mD ^ c5 << 7;
            m0 = m0 << 5 | m0 >>> 27;
            c8 = c8 << 22 | c8 >>> 10;
            m1 = m1 << 13 | m1 >>> 19;
            c9 = c9 << 3 | c9 >>> 29;
            m4 ^= m1 ^ c9;
            cE ^= c9 ^ m1 << 3;
            m4 = m4 << 1 | m4 >>> 31;
            cE = cE << 7 | cE >>> 25;
            m1 ^= m4 ^ cE;
            c9 ^= cE ^ m4 << 7;
            m1 = m1 << 5 | m1 >>> 27;
            c9 = c9 << 22 | c9 >>> 10;
            c0 = c0 << 13 | c0 >>> 19;
            mA = mA << 3 | mA >>> 29;
            m5 ^= c0 ^ mA;
            cF ^= mA ^ c0 << 3;
            m5 = m5 << 1 | m5 >>> 31;
            cF = cF << 7 | cF >>> 25;
            c0 ^= m5 ^ cF;
            mA ^= cF ^ m5 << 7;
            c0 = c0 << 5 | c0 >>> 27;
            mA = mA << 22 | mA >>> 10;
            c1 = c1 << 13 | c1 >>> 19;
            mB = mB << 3 | mB >>> 29;
            c6 ^= c1 ^ mB;
            mE ^= mB ^ c1 << 3;
            c6 = c6 << 1 | c6 >>> 31;
            mE = mE << 7 | mE >>> 25;
            c1 ^= c6 ^ mE;
            mB ^= mE ^ c6 << 7;
            c1 = c1 << 5 | c1 >>> 27;
            mB = mB << 22 | mB >>> 10;
            m2 = m2 << 13 | m2 >>> 19;
            cA = cA << 3 | cA >>> 29;
            c7 ^= m2 ^ cA;
            mF ^= cA ^ m2 << 3;
            c7 = c7 << 1 | c7 >>> 31;
            mF = mF << 7 | mF >>> 25;
            m2 ^= c7 ^ mF;
            cA ^= mF ^ c7 << 7;
            m2 = m2 << 5 | m2 >>> 27;
            cA = cA << 22 | cA >>> 10;
            m3 = m3 << 13 | m3 >>> 19;
            cB = cB << 3 | cB >>> 29;
            m6 ^= m3 ^ cB;
            cC ^= cB ^ m3 << 3;
            m6 = m6 << 1 | m6 >>> 31;
            cC = cC << 7 | cC >>> 25;
            m3 ^= m6 ^ cC;
            cB ^= cC ^ m6 << 7;
            m3 = m3 << 5 | m3 >>> 27;
            cB = cB << 22 | cB >>> 10;
            c2 = c2 << 13 | c2 >>> 19;
            m8 = m8 << 3 | m8 >>> 29;
            m7 ^= c2 ^ m8;
            cD ^= m8 ^ c2 << 3;
            m7 = m7 << 1 | m7 >>> 31;
            cD = cD << 7 | cD >>> 25;
            c2 ^= m7 ^ cD;
            m8 ^= cD ^ m7 << 7;
            c2 = c2 << 5 | c2 >>> 27;
            m8 = m8 << 22 | m8 >>> 10;
            c3 = c3 << 13 | c3 >>> 19;
            m9 = m9 << 3 | m9 >>> 29;
            c4 ^= c3 ^ m9;
            mC ^= m9 ^ c3 << 3;
            c4 = c4 << 1 | c4 >>> 31;
            mC = mC << 7 | mC >>> 25;
            c3 ^= c4 ^ mC;
            m9 ^= mC ^ c4 << 7;
            c3 = c3 << 5 | c3 >>> 27;
            m9 = m9 << 22 | m9 >>> 10;
            m0 = m0 << 13 | m0 >>> 19;
            m3 = m3 << 3 | m3 >>> 29;
            c0 ^= m0 ^ m3;
            c3 ^= m3 ^ m0 << 3;
            c0 = c0 << 1 | c0 >>> 31;
            c3 = c3 << 7 | c3 >>> 25;
            m0 ^= c0 ^ c3;
            m3 ^= c3 ^ c0 << 7;
            m0 = m0 << 5 | m0 >>> 27;
            m3 = m3 << 22 | m3 >>> 10;
            m8 = m8 << 13 | m8 >>> 19;
            mB = mB << 3 | mB >>> 29;
            c9 ^= m8 ^ mB;
            cA ^= mB ^ m8 << 3;
            c9 = c9 << 1 | c9 >>> 31;
            cA = cA << 7 | cA >>> 25;
            m8 ^= c9 ^ cA;
            mB ^= cA ^ c9 << 7;
            m8 = m8 << 5 | m8 >>> 27;
            mB = mB << 22 | mB >>> 10;
            c5 = c5 << 13 | c5 >>> 19;
            c6 = c6 << 3 | c6 >>> 29;
            m5 ^= c5 ^ c6;
            m6 ^= c6 ^ c5 << 3;
            m5 = m5 << 1 | m5 >>> 31;
            m6 = m6 << 7 | m6 >>> 25;
            c5 ^= m5 ^ m6;
            c6 ^= m6 ^ m5 << 7;
            c5 = c5 << 5 | c5 >>> 27;
            c6 = c6 << 22 | c6 >>> 10;
            cD = cD << 13 | cD >>> 19;
            cE = cE << 3 | cE >>> 29;
            mC ^= cD ^ cE;
            mF ^= cE ^ cD << 3;
            mC = mC << 1 | mC >>> 31;
            mF = mF << 7 | mF >>> 25;
            cD ^= mC ^ mF;
            cE ^= mF ^ mC << 7;
            cD = cD << 5 | cD >>> 27;
            cE = cE << 22 | cE >>> 10;
        }
        this.h[15] = this.h[15] ^ cB;
        this.h[14] = this.h[14] ^ cA;
        this.h[13] = this.h[13] ^ mB;
        this.h[12] = this.h[12] ^ mA;
        this.h[11] = this.h[11] ^ c9;
        this.h[10] = this.h[10] ^ c8;
        this.h[9] = this.h[9] ^ m9;
        this.h[8] = this.h[8] ^ m8;
        this.h[7] = this.h[7] ^ c3;
        this.h[6] = this.h[6] ^ c2;
        this.h[5] = this.h[5] ^ m3;
        this.h[4] = this.h[4] ^ m2;
        this.h[3] = this.h[3] ^ c1;
        this.h[2] = this.h[2] ^ c0;
        this.h[1] = this.h[1] ^ m1;
        this.h[0] = this.h[0] ^ m0;
    }

    @Override
    public String toString() {
        return "Hamsi-" + (this.getDigestLength() << 3);
    }
}

