/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

public class HMAC
extends DigestEngine {
    private Digest dig;
    private byte[] kipad;
    private byte[] kopad;
    private int outputLength;
    private byte[] tmpOut;
    private int onlyThis = 0;
    private static final byte[] zeroPad = new byte[64];

    public HMAC(Digest dig, byte[] key) {
        dig.reset();
        this.dig = dig;
        int B = dig.getBlockLength();
        if (B < 0) {
            int n = -B;
            B = n * ((key.length + (n - 1)) / n);
        }
        byte[] keyB = new byte[B];
        int len = key.length;
        if (len > B && (len = (key = dig.digest(key)).length) > B) {
            len = B;
        }
        System.arraycopy(key, 0, keyB, 0, len);
        this.processKey(keyB);
        this.outputLength = -1;
        this.tmpOut = new byte[dig.getDigestLength()];
        this.reset();
    }

    public HMAC(Digest dig, byte[] key, int outputLength) {
        this(dig, key);
        if (outputLength < dig.getDigestLength()) {
            this.outputLength = outputLength;
        }
    }

    private HMAC(Digest dig, byte[] kipad, byte[] kopad, int outputLength) {
        this.dig = dig;
        this.kipad = kipad;
        this.kopad = kopad;
        this.outputLength = outputLength;
        this.tmpOut = new byte[dig.getDigestLength()];
    }

    private void processKey(byte[] keyB) {
        int B = keyB.length;
        this.kipad = new byte[B];
        this.kopad = new byte[B];
        for (int i = 0; i < B; ++i) {
            byte x = keyB[i];
            this.kipad[i] = (byte)(x ^ 0x36);
            this.kopad[i] = (byte)(x ^ 0x5C);
        }
    }

    @Override
    public Digest copy() {
        HMAC h = new HMAC(this.dig.copy(), this.kipad, this.kopad, this.outputLength);
        return this.copyState(h);
    }

    @Override
    public int getDigestLength() {
        return this.outputLength < 0 ? this.dig.getDigestLength() : this.outputLength;
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    @Override
    protected void engineReset() {
        this.dig.reset();
        this.dig.update(this.kipad);
    }

    @Override
    protected void processBlock(byte[] data) {
        if (this.onlyThis > 0) {
            this.dig.update(data, 0, this.onlyThis);
            this.onlyThis = 0;
        } else {
            this.dig.update(data);
        }
    }

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        this.onlyThis = this.flush();
        if (this.onlyThis > 0) {
            this.update(zeroPad, 0, 64 - this.onlyThis);
        }
        int olen = this.tmpOut.length;
        this.dig.digest(this.tmpOut, 0, olen);
        this.dig.update(this.kopad);
        this.dig.update(this.tmpOut);
        this.dig.digest(this.tmpOut, 0, olen);
        if (this.outputLength >= 0) {
            olen = this.outputLength;
        }
        System.arraycopy(this.tmpOut, 0, output, outputOffset, olen);
    }

    @Override
    protected void doInit() {
    }

    @Override
    public String toString() {
        return "HMAC/" + this.dig.toString();
    }
}

