/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class CubeHashCore
extends DigestEngine {
    private int x0;
    private int x1;
    private int x2;
    private int x3;
    private int x4;
    private int x5;
    private int x6;
    private int x7;
    private int x8;
    private int x9;
    private int xa;
    private int xb;
    private int xc;
    private int xd;
    private int xe;
    private int xf;
    private int xg;
    private int xh;
    private int xi;
    private int xj;
    private int xk;
    private int xl;
    private int xm;
    private int xn;
    private int xo;
    private int xp;
    private int xq;
    private int xr;
    private int xs;
    private int xt;
    private int xu;
    private int xv;

    CubeHashCore() {
    }

    private final void inputBlock(byte[] data) {
        this.x0 ^= CubeHashCore.decodeLEInt(data, 0);
        this.x1 ^= CubeHashCore.decodeLEInt(data, 4);
        this.x2 ^= CubeHashCore.decodeLEInt(data, 8);
        this.x3 ^= CubeHashCore.decodeLEInt(data, 12);
        this.x4 ^= CubeHashCore.decodeLEInt(data, 16);
        this.x5 ^= CubeHashCore.decodeLEInt(data, 20);
        this.x6 ^= CubeHashCore.decodeLEInt(data, 24);
        this.x7 ^= CubeHashCore.decodeLEInt(data, 28);
    }

    private final void sixteenRounds() {
        for (int i = 0; i < 8; ++i) {
            this.xg = this.x0 + this.xg;
            this.x0 = this.x0 << 7 | this.x0 >>> 25;
            this.xh = this.x1 + this.xh;
            this.x1 = this.x1 << 7 | this.x1 >>> 25;
            this.xi = this.x2 + this.xi;
            this.x2 = this.x2 << 7 | this.x2 >>> 25;
            this.xj = this.x3 + this.xj;
            this.x3 = this.x3 << 7 | this.x3 >>> 25;
            this.xk = this.x4 + this.xk;
            this.x4 = this.x4 << 7 | this.x4 >>> 25;
            this.xl = this.x5 + this.xl;
            this.x5 = this.x5 << 7 | this.x5 >>> 25;
            this.xm = this.x6 + this.xm;
            this.x6 = this.x6 << 7 | this.x6 >>> 25;
            this.xn = this.x7 + this.xn;
            this.x7 = this.x7 << 7 | this.x7 >>> 25;
            this.xo = this.x8 + this.xo;
            this.x8 = this.x8 << 7 | this.x8 >>> 25;
            this.xp = this.x9 + this.xp;
            this.x9 = this.x9 << 7 | this.x9 >>> 25;
            this.xq = this.xa + this.xq;
            this.xa = this.xa << 7 | this.xa >>> 25;
            this.xr = this.xb + this.xr;
            this.xb = this.xb << 7 | this.xb >>> 25;
            this.xs = this.xc + this.xs;
            this.xc = this.xc << 7 | this.xc >>> 25;
            this.xt = this.xd + this.xt;
            this.xd = this.xd << 7 | this.xd >>> 25;
            this.xu = this.xe + this.xu;
            this.xe = this.xe << 7 | this.xe >>> 25;
            this.xv = this.xf + this.xv;
            this.xf = this.xf << 7 | this.xf >>> 25;
            this.x8 ^= this.xg;
            this.x9 ^= this.xh;
            this.xa ^= this.xi;
            this.xb ^= this.xj;
            this.xc ^= this.xk;
            this.xd ^= this.xl;
            this.xe ^= this.xm;
            this.xf ^= this.xn;
            this.x0 ^= this.xo;
            this.x1 ^= this.xp;
            this.x2 ^= this.xq;
            this.x3 ^= this.xr;
            this.x4 ^= this.xs;
            this.x5 ^= this.xt;
            this.x6 ^= this.xu;
            this.x7 ^= this.xv;
            this.xi = this.x8 + this.xi;
            this.x8 = this.x8 << 11 | this.x8 >>> 21;
            this.xj = this.x9 + this.xj;
            this.x9 = this.x9 << 11 | this.x9 >>> 21;
            this.xg = this.xa + this.xg;
            this.xa = this.xa << 11 | this.xa >>> 21;
            this.xh = this.xb + this.xh;
            this.xb = this.xb << 11 | this.xb >>> 21;
            this.xm = this.xc + this.xm;
            this.xc = this.xc << 11 | this.xc >>> 21;
            this.xn = this.xd + this.xn;
            this.xd = this.xd << 11 | this.xd >>> 21;
            this.xk = this.xe + this.xk;
            this.xe = this.xe << 11 | this.xe >>> 21;
            this.xl = this.xf + this.xl;
            this.xf = this.xf << 11 | this.xf >>> 21;
            this.xq = this.x0 + this.xq;
            this.x0 = this.x0 << 11 | this.x0 >>> 21;
            this.xr = this.x1 + this.xr;
            this.x1 = this.x1 << 11 | this.x1 >>> 21;
            this.xo = this.x2 + this.xo;
            this.x2 = this.x2 << 11 | this.x2 >>> 21;
            this.xp = this.x3 + this.xp;
            this.x3 = this.x3 << 11 | this.x3 >>> 21;
            this.xu = this.x4 + this.xu;
            this.x4 = this.x4 << 11 | this.x4 >>> 21;
            this.xv = this.x5 + this.xv;
            this.x5 = this.x5 << 11 | this.x5 >>> 21;
            this.xs = this.x6 + this.xs;
            this.x6 = this.x6 << 11 | this.x6 >>> 21;
            this.xt = this.x7 + this.xt;
            this.x7 = this.x7 << 11 | this.x7 >>> 21;
            this.xc ^= this.xi;
            this.xd ^= this.xj;
            this.xe ^= this.xg;
            this.xf ^= this.xh;
            this.x8 ^= this.xm;
            this.x9 ^= this.xn;
            this.xa ^= this.xk;
            this.xb ^= this.xl;
            this.x4 ^= this.xq;
            this.x5 ^= this.xr;
            this.x6 ^= this.xo;
            this.x7 ^= this.xp;
            this.x0 ^= this.xu;
            this.x1 ^= this.xv;
            this.x2 ^= this.xs;
            this.x3 ^= this.xt;
            this.xj = this.xc + this.xj;
            this.xc = this.xc << 7 | this.xc >>> 25;
            this.xi = this.xd + this.xi;
            this.xd = this.xd << 7 | this.xd >>> 25;
            this.xh = this.xe + this.xh;
            this.xe = this.xe << 7 | this.xe >>> 25;
            this.xg = this.xf + this.xg;
            this.xf = this.xf << 7 | this.xf >>> 25;
            this.xn = this.x8 + this.xn;
            this.x8 = this.x8 << 7 | this.x8 >>> 25;
            this.xm = this.x9 + this.xm;
            this.x9 = this.x9 << 7 | this.x9 >>> 25;
            this.xl = this.xa + this.xl;
            this.xa = this.xa << 7 | this.xa >>> 25;
            this.xk = this.xb + this.xk;
            this.xb = this.xb << 7 | this.xb >>> 25;
            this.xr = this.x4 + this.xr;
            this.x4 = this.x4 << 7 | this.x4 >>> 25;
            this.xq = this.x5 + this.xq;
            this.x5 = this.x5 << 7 | this.x5 >>> 25;
            this.xp = this.x6 + this.xp;
            this.x6 = this.x6 << 7 | this.x6 >>> 25;
            this.xo = this.x7 + this.xo;
            this.x7 = this.x7 << 7 | this.x7 >>> 25;
            this.xv = this.x0 + this.xv;
            this.x0 = this.x0 << 7 | this.x0 >>> 25;
            this.xu = this.x1 + this.xu;
            this.x1 = this.x1 << 7 | this.x1 >>> 25;
            this.xt = this.x2 + this.xt;
            this.x2 = this.x2 << 7 | this.x2 >>> 25;
            this.xs = this.x3 + this.xs;
            this.x3 = this.x3 << 7 | this.x3 >>> 25;
            this.x4 ^= this.xj;
            this.x5 ^= this.xi;
            this.x6 ^= this.xh;
            this.x7 ^= this.xg;
            this.x0 ^= this.xn;
            this.x1 ^= this.xm;
            this.x2 ^= this.xl;
            this.x3 ^= this.xk;
            this.xc ^= this.xr;
            this.xd ^= this.xq;
            this.xe ^= this.xp;
            this.xf ^= this.xo;
            this.x8 ^= this.xv;
            this.x9 ^= this.xu;
            this.xa ^= this.xt;
            this.xb ^= this.xs;
            this.xh = this.x4 + this.xh;
            this.x4 = this.x4 << 11 | this.x4 >>> 21;
            this.xg = this.x5 + this.xg;
            this.x5 = this.x5 << 11 | this.x5 >>> 21;
            this.xj = this.x6 + this.xj;
            this.x6 = this.x6 << 11 | this.x6 >>> 21;
            this.xi = this.x7 + this.xi;
            this.x7 = this.x7 << 11 | this.x7 >>> 21;
            this.xl = this.x0 + this.xl;
            this.x0 = this.x0 << 11 | this.x0 >>> 21;
            this.xk = this.x1 + this.xk;
            this.x1 = this.x1 << 11 | this.x1 >>> 21;
            this.xn = this.x2 + this.xn;
            this.x2 = this.x2 << 11 | this.x2 >>> 21;
            this.xm = this.x3 + this.xm;
            this.x3 = this.x3 << 11 | this.x3 >>> 21;
            this.xp = this.xc + this.xp;
            this.xc = this.xc << 11 | this.xc >>> 21;
            this.xo = this.xd + this.xo;
            this.xd = this.xd << 11 | this.xd >>> 21;
            this.xr = this.xe + this.xr;
            this.xe = this.xe << 11 | this.xe >>> 21;
            this.xq = this.xf + this.xq;
            this.xf = this.xf << 11 | this.xf >>> 21;
            this.xt = this.x8 + this.xt;
            this.x8 = this.x8 << 11 | this.x8 >>> 21;
            this.xs = this.x9 + this.xs;
            this.x9 = this.x9 << 11 | this.x9 >>> 21;
            this.xv = this.xa + this.xv;
            this.xa = this.xa << 11 | this.xa >>> 21;
            this.xu = this.xb + this.xu;
            this.xb = this.xb << 11 | this.xb >>> 21;
            this.x0 ^= this.xh;
            this.x1 ^= this.xg;
            this.x2 ^= this.xj;
            this.x3 ^= this.xi;
            this.x4 ^= this.xl;
            this.x5 ^= this.xk;
            this.x6 ^= this.xn;
            this.x7 ^= this.xm;
            this.x8 ^= this.xp;
            this.x9 ^= this.xo;
            this.xa ^= this.xr;
            this.xb ^= this.xq;
            this.xc ^= this.xt;
            this.xd ^= this.xs;
            this.xe ^= this.xv;
            this.xf ^= this.xu;
        }
    }

    private static final void encodeLEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)val;
        buf[off + 1] = (byte)(val >>> 8);
        buf[off + 2] = (byte)(val >>> 16);
        buf[off + 3] = (byte)(val >>> 24);
    }

    private static final int decodeLEInt(byte[] buf, int off) {
        return buf[off + 0] & 0xFF | (buf[off + 1] & 0xFF) << 8 | (buf[off + 2] & 0xFF) << 16 | (buf[off + 3] & 0xFF) << 24;
    }

    @Override
    protected void engineReset() {
        this.doReset();
    }

    @Override
    protected void processBlock(byte[] data) {
        this.inputBlock(data);
        this.sixteenRounds();
    }

    @Override
    protected void doPadding(byte[] out, int off) {
        int ptr = this.flush();
        byte[] buf = this.getBlockBuffer();
        buf[ptr++] = -128;
        while (ptr < 32) {
            buf[ptr++] = 0;
        }
        this.inputBlock(buf);
        this.sixteenRounds();
        this.xv ^= 1;
        for (int j = 0; j < 10; ++j) {
            this.sixteenRounds();
        }
        int dlen = this.getDigestLength();
        CubeHashCore.encodeLEInt(this.x0, out, off + 0);
        CubeHashCore.encodeLEInt(this.x1, out, off + 4);
        CubeHashCore.encodeLEInt(this.x2, out, off + 8);
        CubeHashCore.encodeLEInt(this.x3, out, off + 12);
        CubeHashCore.encodeLEInt(this.x4, out, off + 16);
        CubeHashCore.encodeLEInt(this.x5, out, off + 20);
        CubeHashCore.encodeLEInt(this.x6, out, off + 24);
        if (dlen == 28) {
            return;
        }
        CubeHashCore.encodeLEInt(this.x7, out, off + 28);
        if (dlen == 32) {
            return;
        }
        CubeHashCore.encodeLEInt(this.x8, out, off + 32);
        CubeHashCore.encodeLEInt(this.x9, out, off + 36);
        CubeHashCore.encodeLEInt(this.xa, out, off + 40);
        CubeHashCore.encodeLEInt(this.xb, out, off + 44);
        if (dlen == 48) {
            return;
        }
        CubeHashCore.encodeLEInt(this.xc, out, off + 48);
        CubeHashCore.encodeLEInt(this.xd, out, off + 52);
        CubeHashCore.encodeLEInt(this.xe, out, off + 56);
        CubeHashCore.encodeLEInt(this.xf, out, off + 60);
    }

    @Override
    protected void doInit() {
        this.doReset();
    }

    abstract int[] getIV();

    @Override
    public int getInternalBlockLength() {
        return 32;
    }

    @Override
    public int getBlockLength() {
        return -32;
    }

    private final void doReset() {
        int[] iv = this.getIV();
        this.x0 = iv[0];
        this.x1 = iv[1];
        this.x2 = iv[2];
        this.x3 = iv[3];
        this.x4 = iv[4];
        this.x5 = iv[5];
        this.x6 = iv[6];
        this.x7 = iv[7];
        this.x8 = iv[8];
        this.x9 = iv[9];
        this.xa = iv[10];
        this.xb = iv[11];
        this.xc = iv[12];
        this.xd = iv[13];
        this.xe = iv[14];
        this.xf = iv[15];
        this.xg = iv[16];
        this.xh = iv[17];
        this.xi = iv[18];
        this.xj = iv[19];
        this.xk = iv[20];
        this.xl = iv[21];
        this.xm = iv[22];
        this.xn = iv[23];
        this.xo = iv[24];
        this.xp = iv[25];
        this.xq = iv[26];
        this.xr = iv[27];
        this.xs = iv[28];
        this.xt = iv[29];
        this.xu = iv[30];
        this.xv = iv[31];
    }

    protected Digest copyState(CubeHashCore dst) {
        dst.x0 = this.x0;
        dst.x1 = this.x1;
        dst.x2 = this.x2;
        dst.x3 = this.x3;
        dst.x4 = this.x4;
        dst.x5 = this.x5;
        dst.x6 = this.x6;
        dst.x7 = this.x7;
        dst.x8 = this.x8;
        dst.x9 = this.x9;
        dst.xa = this.xa;
        dst.xb = this.xb;
        dst.xc = this.xc;
        dst.xd = this.xd;
        dst.xe = this.xe;
        dst.xf = this.xf;
        dst.xg = this.xg;
        dst.xh = this.xh;
        dst.xi = this.xi;
        dst.xj = this.xj;
        dst.xk = this.xk;
        dst.xl = this.xl;
        dst.xm = this.xm;
        dst.xn = this.xn;
        dst.xo = this.xo;
        dst.xp = this.xp;
        dst.xq = this.xq;
        dst.xr = this.xr;
        dst.xs = this.xs;
        dst.xt = this.xt;
        dst.xu = this.xu;
        dst.xv = this.xv;
        return super.copyState(dst);
    }

    @Override
    public String toString() {
        return "CubeHash-" + (this.getDigestLength() << 3);
    }
}

