/*
 * Decompiled with CFR 0.152.
 */
package fr.cryptohash;

import fr.cryptohash.Digest;
import fr.cryptohash.DigestEngine;

abstract class BLAKESmallCore
extends DigestEngine {
    private static final int[] SIGMA = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3, 11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4, 7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8, 9, 0, 5, 7, 2, 4, 10, 15, 14, 1, 11, 12, 6, 8, 3, 13, 2, 12, 6, 10, 0, 11, 8, 3, 4, 13, 7, 5, 15, 14, 1, 9, 12, 5, 1, 15, 14, 13, 4, 10, 0, 7, 6, 3, 9, 2, 8, 11, 13, 11, 7, 14, 12, 1, 3, 9, 5, 0, 15, 4, 8, 6, 2, 10, 6, 15, 14, 9, 11, 3, 0, 8, 12, 2, 13, 7, 1, 4, 10, 5, 10, 2, 8, 4, 7, 6, 1, 5, 15, 11, 9, 14, 3, 12, 13, 0, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 14, 10, 4, 8, 9, 15, 13, 6, 1, 12, 0, 2, 11, 7, 5, 3, 11, 8, 12, 0, 5, 2, 15, 13, 10, 14, 3, 6, 7, 1, 9, 4, 7, 9, 3, 1, 13, 12, 11, 14, 2, 6, 5, 10, 4, 0, 15, 8};
    private static final int[] CS = new int[]{608135816, -2052912941, 320440878, 57701188, -1542899678, 698298832, 137296536, -330404727, 1160258022, 953160567, -1101764913, 887688300, -1062458953, -914599715, 1065670069, -1253635817};
    private int h0;
    private int h1;
    private int h2;
    private int h3;
    private int h4;
    private int h5;
    private int h6;
    private int h7;
    private int s0;
    private int s1;
    private int s2;
    private int s3;
    private int t0;
    private int t1;
    private int[] tmpM;
    private byte[] tmpBuf;

    BLAKESmallCore() {
    }

    @Override
    public int getBlockLength() {
        return 64;
    }

    protected Digest copyState(BLAKESmallCore dst) {
        dst.h0 = this.h0;
        dst.h1 = this.h1;
        dst.h2 = this.h2;
        dst.h3 = this.h3;
        dst.h4 = this.h4;
        dst.h5 = this.h5;
        dst.h6 = this.h6;
        dst.h7 = this.h7;
        dst.s0 = this.s0;
        dst.s1 = this.s1;
        dst.s2 = this.s2;
        dst.s3 = this.s3;
        dst.t0 = this.t0;
        dst.t1 = this.t1;
        return super.copyState(dst);
    }

    @Override
    protected void engineReset() {
        int[] iv = this.getInitVal();
        this.h0 = iv[0];
        this.h1 = iv[1];
        this.h2 = iv[2];
        this.h3 = iv[3];
        this.h4 = iv[4];
        this.h5 = iv[5];
        this.h6 = iv[6];
        this.h7 = iv[7];
        this.s3 = 0;
        this.s2 = 0;
        this.s1 = 0;
        this.s0 = 0;
        this.t1 = 0;
        this.t0 = 0;
    }

    abstract int[] getInitVal();

    @Override
    protected void doPadding(byte[] output, int outputOffset) {
        int ptr = this.flush();
        int bitLen = ptr << 3;
        int th = this.t1--;
        int tl = this.t0 + bitLen;
        this.tmpBuf[ptr] = -128;
        if (ptr == 0) {
            this.t0 = -512;
            this.t1 = -1;
        } else {
            this.t0 = this.t0 == 0 ? -512 + bitLen : (this.t0 -= 512 - bitLen);
        }
        if (ptr < 56) {
            for (int i = ptr + 1; i < 56; ++i) {
                this.tmpBuf[i] = 0;
            }
            if (this.getDigestLength() == 32) {
                this.tmpBuf[55] = (byte)(this.tmpBuf[55] | 1);
            }
            BLAKESmallCore.encodeBEInt(th, this.tmpBuf, 56);
            BLAKESmallCore.encodeBEInt(tl, this.tmpBuf, 60);
            this.update(this.tmpBuf, ptr, 64 - ptr);
        } else {
            int i;
            for (i = ptr + 1; i < 64; ++i) {
                this.tmpBuf[i] = 0;
            }
            this.update(this.tmpBuf, ptr, 64 - ptr);
            this.t0 = -512;
            this.t1 = -1;
            for (i = 0; i < 56; ++i) {
                this.tmpBuf[i] = 0;
            }
            if (this.getDigestLength() == 32) {
                this.tmpBuf[55] = 1;
            }
            BLAKESmallCore.encodeBEInt(th, this.tmpBuf, 56);
            BLAKESmallCore.encodeBEInt(tl, this.tmpBuf, 60);
            this.update(this.tmpBuf, 0, 64);
        }
        BLAKESmallCore.encodeBEInt(this.h0, output, outputOffset + 0);
        BLAKESmallCore.encodeBEInt(this.h1, output, outputOffset + 4);
        BLAKESmallCore.encodeBEInt(this.h2, output, outputOffset + 8);
        BLAKESmallCore.encodeBEInt(this.h3, output, outputOffset + 12);
        BLAKESmallCore.encodeBEInt(this.h4, output, outputOffset + 16);
        BLAKESmallCore.encodeBEInt(this.h5, output, outputOffset + 20);
        BLAKESmallCore.encodeBEInt(this.h6, output, outputOffset + 24);
        if (this.getDigestLength() == 32) {
            BLAKESmallCore.encodeBEInt(this.h7, output, outputOffset + 28);
        }
    }

    @Override
    protected void doInit() {
        this.tmpM = new int[16];
        this.tmpBuf = new byte[64];
        this.engineReset();
    }

    private static final void encodeBEInt(int val, byte[] buf, int off) {
        buf[off + 0] = (byte)(val >>> 24);
        buf[off + 1] = (byte)(val >>> 16);
        buf[off + 2] = (byte)(val >>> 8);
        buf[off + 3] = (byte)val;
    }

    private static final int decodeBEInt(byte[] buf, int off) {
        return (buf[off] & 0xFF) << 24 | (buf[off + 1] & 0xFF) << 16 | (buf[off + 2] & 0xFF) << 8 | buf[off + 3] & 0xFF;
    }

    private static int circularRight(int x, int n) {
        return x >>> n | x << 32 - n;
    }

    @Override
    protected void processBlock(byte[] data) {
        this.t0 += 512;
        if ((this.t0 & 0xFFFFFE00) == 0) {
            ++this.t1;
        }
        int v0 = this.h0;
        int v1 = this.h1;
        int v2 = this.h2;
        int v3 = this.h3;
        int v4 = this.h4;
        int v5 = this.h5;
        int v6 = this.h6;
        int v7 = this.h7;
        int v8 = this.s0 ^ 0x243F6A88;
        int v9 = this.s1 ^ 0x85A308D3;
        int vA = this.s2 ^ 0x13198A2E;
        int vB = this.s3 ^ 0x3707344;
        int vC = this.t0 ^ 0xA4093822;
        int vD = this.t0 ^ 0x299F31D0;
        int vE = this.t1 ^ 0x82EFA98;
        int vF = this.t1 ^ 0xEC4E6C89;
        int[] m = this.tmpM;
        for (int i = 0; i < 16; ++i) {
            m[i] = BLAKESmallCore.decodeBEInt(data, 4 * i);
        }
        for (int r = 0; r < 14; ++r) {
            int o0 = SIGMA[(r << 4) + 0];
            int o1 = SIGMA[(r << 4) + 1];
            vC = BLAKESmallCore.circularRight(vC ^ (v0 += v4 + (m[o0] ^ CS[o1])), 16);
            v4 = BLAKESmallCore.circularRight(v4 ^ (v8 += vC), 12);
            vC = BLAKESmallCore.circularRight(vC ^ (v0 += v4 + (m[o1] ^ CS[o0])), 8);
            v4 = BLAKESmallCore.circularRight(v4 ^ (v8 += vC), 7);
            o0 = SIGMA[(r << 4) + 2];
            o1 = SIGMA[(r << 4) + 3];
            vD = BLAKESmallCore.circularRight(vD ^ (v1 += v5 + (m[o0] ^ CS[o1])), 16);
            v5 = BLAKESmallCore.circularRight(v5 ^ (v9 += vD), 12);
            vD = BLAKESmallCore.circularRight(vD ^ (v1 += v5 + (m[o1] ^ CS[o0])), 8);
            v5 = BLAKESmallCore.circularRight(v5 ^ (v9 += vD), 7);
            o0 = SIGMA[(r << 4) + 4];
            o1 = SIGMA[(r << 4) + 5];
            vE = BLAKESmallCore.circularRight(vE ^ (v2 += v6 + (m[o0] ^ CS[o1])), 16);
            v6 = BLAKESmallCore.circularRight(v6 ^ (vA += vE), 12);
            vE = BLAKESmallCore.circularRight(vE ^ (v2 += v6 + (m[o1] ^ CS[o0])), 8);
            v6 = BLAKESmallCore.circularRight(v6 ^ (vA += vE), 7);
            o0 = SIGMA[(r << 4) + 6];
            o1 = SIGMA[(r << 4) + 7];
            vF = BLAKESmallCore.circularRight(vF ^ (v3 += v7 + (m[o0] ^ CS[o1])), 16);
            v7 = BLAKESmallCore.circularRight(v7 ^ (vB += vF), 12);
            vF = BLAKESmallCore.circularRight(vF ^ (v3 += v7 + (m[o1] ^ CS[o0])), 8);
            v7 = BLAKESmallCore.circularRight(v7 ^ (vB += vF), 7);
            o0 = SIGMA[(r << 4) + 8];
            o1 = SIGMA[(r << 4) + 9];
            vF = BLAKESmallCore.circularRight(vF ^ (v0 += v5 + (m[o0] ^ CS[o1])), 16);
            v5 = BLAKESmallCore.circularRight(v5 ^ (vA += vF), 12);
            vF = BLAKESmallCore.circularRight(vF ^ (v0 += v5 + (m[o1] ^ CS[o0])), 8);
            v5 = BLAKESmallCore.circularRight(v5 ^ (vA += vF), 7);
            o0 = SIGMA[(r << 4) + 10];
            o1 = SIGMA[(r << 4) + 11];
            vC = BLAKESmallCore.circularRight(vC ^ (v1 += v6 + (m[o0] ^ CS[o1])), 16);
            v6 = BLAKESmallCore.circularRight(v6 ^ (vB += vC), 12);
            vC = BLAKESmallCore.circularRight(vC ^ (v1 += v6 + (m[o1] ^ CS[o0])), 8);
            v6 = BLAKESmallCore.circularRight(v6 ^ (vB += vC), 7);
            o0 = SIGMA[(r << 4) + 12];
            o1 = SIGMA[(r << 4) + 13];
            vD = BLAKESmallCore.circularRight(vD ^ (v2 += v7 + (m[o0] ^ CS[o1])), 16);
            v7 = BLAKESmallCore.circularRight(v7 ^ (v8 += vD), 12);
            vD = BLAKESmallCore.circularRight(vD ^ (v2 += v7 + (m[o1] ^ CS[o0])), 8);
            v7 = BLAKESmallCore.circularRight(v7 ^ (v8 += vD), 7);
            o0 = SIGMA[(r << 4) + 14];
            o1 = SIGMA[(r << 4) + 15];
            vE = BLAKESmallCore.circularRight(vE ^ (v3 += v4 + (m[o0] ^ CS[o1])), 16);
            v4 = BLAKESmallCore.circularRight(v4 ^ (v9 += vE), 12);
            vE = BLAKESmallCore.circularRight(vE ^ (v3 += v4 + (m[o1] ^ CS[o0])), 8);
            v4 = BLAKESmallCore.circularRight(v4 ^ (v9 += vE), 7);
        }
        this.h0 ^= this.s0 ^ v0 ^ v8;
        this.h1 ^= this.s1 ^ v1 ^ v9;
        this.h2 ^= this.s2 ^ v2 ^ vA;
        this.h3 ^= this.s3 ^ v3 ^ vB;
        this.h4 ^= this.s0 ^ v4 ^ vC;
        this.h5 ^= this.s1 ^ v5 ^ vD;
        this.h6 ^= this.s2 ^ v6 ^ vE;
        this.h7 ^= this.s3 ^ v7 ^ vF;
    }

    @Override
    public String toString() {
        return "BLAKE-" + (this.getDigestLength() << 3);
    }
}

