/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.Radio;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.ConsoleMetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.MetaDataConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.Application;
import su.litvak.chromecast.api.v2.ChromeCast;
import su.litvak.chromecast.api.v2.ChromeCasts;
import su.litvak.chromecast.api.v2.ChromeCastsListener;
import su.litvak.chromecast.api.v2.MediaStatus;

public class StreamCastConsumer
extends MetaDataConsumer
implements Consumer<HttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(StreamCastConsumer.class);
    public static final String APP_ID = "CC1AD845";
    private final ArrayBlockingQueue<ChromeCast> arrayBlockingQueue = new ArrayBlockingQueue(1);
    private ChromeCast chromeCast = null;
    private MediaStatus lastMediaStatus;
    private static final long TRACK_MEDIASTATUS_EVERY_MS = 1000L;

    public StreamCastConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
    }

    private boolean trackMediaStatusShallExit(MediaStatus mediaStatus) {
        boolean result = false;
        if (mediaStatus == null) {
            return false;
        }
        if (this.lastMediaStatus == null || mediaStatus.playerState != this.lastMediaStatus.playerState) {
            log.info("Player state changed to {}", (Object)mediaStatus.playerState);
        }
        if (mediaStatus.playerState.equals((Object)MediaStatus.PlayerState.IDLE)) {
            log.info("Player state is {}. reason: {}", (Object)mediaStatus.playerState, (Object)mediaStatus.idleReason);
            result = true;
        }
        this.lastMediaStatus = mediaStatus;
        return result;
    }

    @Override
    protected void __accept(HttpConnection t, InputStream inputStream) {
        try {
            this.getStreamMetaData().setMetaDataConsumer(new ConsoleMetaDataConsumer());
            ChromeCasts.registerListener((ChromeCastsListener)new MyChromeCastsListener());
            ChromeCasts.startDiscovery();
            log.info("Waiting for chromecast {} to be discovered", (Object)this.getContext().getCastReceiver());
            this.chromeCast = this.arrayBlockingQueue.take();
            log.info("Found chromecast {}", (Object)this.chromeCast);
            this.chromeCast.connect();
            log.info("Connected to chromecast {}", (Object)this.chromeCast);
            Radio radio = this.getContext().getRadio();
            Application app = this.chromeCast.launchApp(APP_ID);
            this.chromeCast.setApplication("Radio Recorder");
            this.chromeCast.setName(radio.getName());
            MediaStatus mediaStatus = this.chromeCast.load("Radio Recorder: " + radio.getName(), radio.getFavIconUrl() != null ? radio.getFavIconUrl().toASCIIString() : null, t.getURI().toASCIIString(), t.getContentType());
            boolean shallExit = this.trackMediaStatusShallExit(mediaStatus);
            if (shallExit) {
                return;
            }
            log.debug("Loaded content to chromecast {}", (Object)this.chromeCast.getTitle());
            byte[] buffer = new byte[8192];
            Thread shutdown = new Thread(this::cleanup);
            Runtime.getRuntime().addShutdownHook(shutdown);
            long lastTrack = System.currentTimeMillis();
            try {
                int length;
                while (-1 != (length = inputStream.read(buffer))) {
                    log.trace("Read {} bytes", (Object)length);
                    if (System.currentTimeMillis() - lastTrack <= 1000L) continue;
                    lastTrack = System.currentTimeMillis();
                    mediaStatus = this.chromeCast.getMediaStatus();
                    shallExit = this.trackMediaStatusShallExit(mediaStatus);
                    if (!shallExit) continue;
                    log.info("Media status said shall exit");
                    return;
                }
            }
            catch (IOException ioe) {
                log.warn("Error reading stream", (Throwable)ioe);
                throw new RadioException(true, (Throwable)ioe);
            }
            Runtime.getRuntime().removeShutdownHook(shutdown);
        }
        catch (IOException | InterruptedException | GeneralSecurityException ex) {
            log.warn("Chromecast problem", (Throwable)ex);
            throw new RadioException(false, (Throwable)ex);
        }
        finally {
            this.cleanup();
        }
    }

    private void cleanup() {
        try {
            if (this.chromeCast != null && this.chromeCast.isConnected()) {
                if (this.chromeCast.isAppRunning(APP_ID)) {
                    this.chromeCast.stopApp();
                }
                this.chromeCast.disconnect();
                log.debug("Disconnected from chromecast {}", (Object)this.chromeCast.getTitle());
                this.chromeCast = null;
            }
            ChromeCasts.stopDiscovery();
            log.debug("Stopped discovery");
        }
        catch (IOException ex) {
            log.warn("Problem disconnecting chromecast", (Throwable)ex);
        }
    }

    private class MyChromeCastsListener
    implements ChromeCastsListener {
        private MyChromeCastsListener() {
        }

        public void newChromeCastDiscovered(ChromeCast chromeCast) {
            if (chromeCast.getTitle().equalsIgnoreCase(StreamCastConsumer.this.getContext().getCastReceiver())) {
                try {
                    log.debug("Found chromecast {}", (Object)chromeCast.getTitle());
                    StreamCastConsumer.this.arrayBlockingQueue.put(chromeCast);
                    log.debug("Posted chromecast {}", (Object)chromeCast.getTitle());
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            } else {
                log.debug("Ignoring chromecast {}", (Object)chromeCast.getTitle());
            }
        }

        public void chromeCastRemoved(ChromeCast chromeCast) {
        }
    }
}

