/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiobrowser4j.ConnectionParams;
import de.sfuhrm.radiobrowser4j.EndpointDiscovery;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.Parameter;
import de.sfuhrm.radiobrowser4j.RadioBrowser;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.ListHelper;
import de.sfuhrm.radiorecorder.Params;
import de.sfuhrm.radiorecorder.Radio;
import de.sfuhrm.radiorecorder.RadioRunnable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.ChromeCast;
import su.litvak.chromecast.api.v2.ChromeCasts;
import su.litvak.chromecast.api.v2.ChromeCastsListener;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static final String GITHUB_URL = "https://github.com/sfuhrm/radiorecorder";
    public static final String PROJECT = "Radio Recorder";
    private static int nextId = 1;
    public static final String NO_RADIO_NAME = "";
    private static final String NO_RESULTS = "No results.";

    private static RadioBrowser newRadioBrowser(Params params) throws IOException {
        EndpointDiscovery endpointDiscovery = new EndpointDiscovery(GITHUB_URL);
        Optional endpoint = endpointDiscovery.discover();
        if (!endpoint.isPresent()) {
            throw new Error("Radiobrowser endpoint discovery failed");
        }
        ConnectionParams.ConnectionParamsBuilder builder = ConnectionParams.builder();
        builder.apiUrl((String)endpoint.get());
        builder.timeout(params.getTimeout() * 1000);
        if (params.getProxy() != null) {
            builder.proxyUri(params.getProxy().toASCIIString());
        }
        builder.userAgent(GITHUB_URL);
        RadioBrowser browser = new RadioBrowser(builder.build());
        return browser;
    }

    private static List<Radio> sanitize(List<String> urls, Params params) throws IOException {
        ArrayList<Radio> result = new ArrayList<Radio>();
        RadioBrowser radioBrowser = Main.newRadioBrowser(params);
        int limit = params.getStationLimit();
        for (String urlString : urls) {
            List radios;
            List stations;
            URI uri = URI.create(urlString);
            String scheme = uri.getScheme();
            if (scheme != null) {
                Radio s = new Radio();
                s.setName(NO_RADIO_NAME);
                s.setUri(uri);
                result.add(s);
                continue;
            }
            log.debug("Parameter not an URL: {}", (Object)urlString);
            try {
                UUID uuid = UUID.fromString(urlString);
                stations = radioBrowser.listStationsBy(SearchMode.BYUUID, uuid.toString(), new Parameter[0]).collect(Collectors.toList());
                radios = stations.stream().map(Radio::fromStation).collect(Collectors.toList());
                result.addAll(radios);
            }
            catch (IllegalArgumentException e) {
                log.debug("Parameter not an UUID: {}", (Object)urlString);
                stations = radioBrowser.listStationsBy(Paging.at((int)0, (int)limit), SearchMode.BYNAME, urlString, new Parameter[0]);
                radios = stations.stream().map(Radio::fromStation).collect(Collectors.toList());
                result.addAll(radios);
            }
        }
        return result;
    }

    private static ConsumerContext toConsumerContext(Params p, Radio radio) throws MalformedURLException {
        return new ConsumerContext(nextId++, radio, p);
    }

    private static void listCastDevices() throws InterruptedException, IOException {
        int castSearchMillis = 5000;
        log.info("Please wait {}ms while discovering devices...", (Object)castSearchMillis);
        MyListener instance = new MyListener();
        ChromeCasts.registerListener((ChromeCastsListener)instance);
        ChromeCasts.startDiscovery();
        Thread.sleep(castSearchMillis);
        ChromeCasts.stopDiscovery();
        if (instance.discovered.isEmpty()) {
            log.warn(NO_RESULTS);
            return;
        }
        ListHelper<CastItem> helper = new ListHelper<CastItem>(instance.discovered);
        helper.addColumn("Title", CastItem::getTitle);
        helper.addColumn("Model", CastItem::getModel);
        helper.addColumn("Address", CastItem::getAddress);
        helper.addColumn("App Title", CastItem::getAppTitle);
        helper.print(System.out);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Params params = Params.parse(args);
        if (params == null) {
            return;
        }
        if (params.isListCast()) {
            Main.listCastDevices();
            return;
        }
        if (params.isListStation()) {
            Main.listStations(params.getArguments(), params);
            return;
        }
        if (params.isListMixers()) {
            Main.listMixers();
            return;
        }
        Collection<Radio> radios = Main.sanitize(params.getArguments(), params);
        if (params.isPlay() && radios.isEmpty()) {
            log.warn("No search results for the search arguments: {}", params.getArguments());
            return;
        }
        if (params.isPlay() && radios.size() > 1) {
            radios = radios.stream().limit(1L).collect(Collectors.toList());
            log.warn("Restricting to first station because playing.");
        }
        ArrayList<Thread> threadList = new ArrayList<Thread>();
        radios.stream().forEach(radio -> {
            try {
                log.info("Starting radio: {}", radio);
                RadioRunnable r = new RadioRunnable(Main.toConsumerContext(params, radio));
                Thread t = new Thread((Runnable)r, "Radio " + radio.getUuid());
                threadList.add(t);
                t.start();
            }
            catch (IOException ex) {
                log.warn("Could not start thread for station url " + radio.getUri(), (Throwable)ex);
            }
        });
        log.info("Waiting for background processes to finish");
        Main.joinThreads(threadList);
    }

    private static void joinThreads(List<Thread> threadList) {
        threadList.forEach(t -> {
            try {
                t.join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private static void listMixers() {
        List<Mixer.Info> infoList = Arrays.asList(AudioSystem.getMixerInfo());
        if (infoList.isEmpty()) {
            log.warn(NO_RESULTS);
            return;
        }
        ListHelper<Mixer.Info> helper = new ListHelper<Mixer.Info>(infoList);
        helper.addColumn("Name", Mixer.Info::getName);
        helper.addColumn("Description", Mixer.Info::getDescription);
        helper.addColumn("Vendor", Mixer.Info::getVendor);
        helper.print(System.out);
    }

    private static void listStations(List<String> names, Params params) throws IOException {
        List<Radio> radios = Main.sanitize(names, params);
        if (radios.isEmpty()) {
            log.warn(NO_RESULTS);
            return;
        }
        ListHelper<Radio> helper = new ListHelper<Radio>(radios);
        helper.addColumn("UUID", s -> s.getUuid().toString());
        helper.addColumn("Name", Radio::getName);
        helper.addColumn("Codec", Radio::getCodec);
        helper.addColumn("BR", s -> String.format("%d", s.getBitrate()));
        helper.addColumn("Tags", s -> s.getTags().toString());
        helper.print(System.out);
    }

    private static class MyListener
    implements ChromeCastsListener {
        private final List<CastItem> discovered = new ArrayList<CastItem>();

        private MyListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void newChromeCastDiscovered(ChromeCast chromeCast) {
            CastItem castItem = new CastItem(chromeCast.getTitle(), chromeCast.getModel(), chromeCast.getAddress(), chromeCast.getAppTitle());
            List<CastItem> list = this.discovered;
            synchronized (list) {
                this.discovered.add(castItem);
            }
        }

        public void chromeCastRemoved(ChromeCast chromeCast) {
        }
    }

    private static final class CastItem {
        private final String title;
        private final String model;
        private final String address;
        private final String appTitle;

        public CastItem(String title, String model, String address, String appTitle) {
            this.title = title;
            this.model = model;
            this.address = address;
            this.appTitle = appTitle;
        }

        public String getTitle() {
            return this.title;
        }

        public String getModel() {
            return this.model;
        }

        public String getAddress() {
            return this.address;
        }

        public String getAppTitle() {
            return this.appTitle;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CastItem)) {
                return false;
            }
            CastItem other = (CastItem)o;
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$model = this.getModel();
            String other$model = other.getModel();
            if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$appTitle = this.getAppTitle();
            String other$appTitle = other.getAppTitle();
            return !(this$appTitle == null ? other$appTitle != null : !this$appTitle.equals(other$appTitle));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $model = this.getModel();
            result = result * 59 + ($model == null ? 43 : $model.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $appTitle = this.getAppTitle();
            result = result * 59 + ($appTitle == null ? 43 : $appTitle.hashCode());
            return result;
        }

        public String toString() {
            return "Main.CastItem(title=" + this.getTitle() + ", model=" + this.getModel() + ", address=" + this.getAddress() + ", appTitle=" + this.getAppTitle() + ")";
        }
    }
}

