/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiobrowser4j.Station;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Radio {
    private static final Logger log = LoggerFactory.getLogger(Radio.class);
    private String name;
    private URI uri;
    private UUID uuid;
    private URI favIconUrl;
    private String codec;
    private int bitrate;
    private List<String> tags = Collections.emptyList();

    static Radio fromStation(Station s) {
        Radio r = new Radio();
        r.setName(s.getName());
        if (s.getUrl() != null) {
            URI uri = URI.create(s.getUrl());
            r.setUri(uri);
        }
        r.setUuid(s.getStationUUID());
        if (s.getFavicon() != null && !s.getFavicon().isEmpty()) {
            r.setFavIconUrl(URI.create(s.getFavicon()));
        }
        r.setCodec(s.getCodec());
        if (s.getBitrate() != null) {
            r.setBitrate(s.getBitrate());
        }
        r.setTags(new ArrayList<String>(r.getTags()));
        return r;
    }

    public String getName() {
        return this.name;
    }

    public URI getUri() {
        return this.uri;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public URI getFavIconUrl() {
        return this.favIconUrl;
    }

    public String getCodec() {
        return this.codec;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setFavIconUrl(URI favIconUrl) {
        this.favIconUrl = favIconUrl;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "Radio(name=" + this.getName() + ", uri=" + this.getUri() + ", uuid=" + this.getUuid() + ", favIconUrl=" + this.getFavIconUrl() + ", codec=" + this.getCodec() + ", bitrate=" + this.getBitrate() + ", tags=" + this.getTags() + ")";
    }
}

