/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;

public enum MimeType {
    AUDIO_MPEG("audio/mpeg", ".mp3"),
    AUDIO_OGG("audio/ogg", ".ogg"),
    AUDIO_XWAV("audio/x-wav", ".wav"),
    AUDIO_XMSWMA("audio/x-ms-wma", ".wma"),
    AUDIO_MPEGURL("audio/mpegurl", ".m3u"),
    AUDIO_XMPEGURL("audio/x-mpegurl", ".m3u"),
    AUDIO_XSCPLS("audio/x-scpls", ".pls"),
    APPLICATION_OGG("application/ogg", ".ogg"),
    APPLICATION_PLS_XML("application/pls+xml", ".pls"),
    AUDIO_AAC(new String[]{"audio/aac", "audio/aacp", "audio/mp4"}, ".m4a");

    private final String[] contentTypes;
    private final String suffix;

    private MimeType(String contentType, String suffix) {
        if (contentType == null) {
            throw new NullPointerException("contentType is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        this.contentTypes = new String[]{contentType};
        this.suffix = suffix;
    }

    private MimeType(String[] contentTypes, String suffix) {
        if (contentTypes == null) {
            throw new NullPointerException("contentTypes is marked non-null but is null");
        }
        if (suffix == null) {
            throw new NullPointerException("suffix is marked non-null but is null");
        }
        this.contentTypes = Arrays.copyOf(contentTypes, contentTypes.length);
        this.suffix = suffix;
    }

    boolean matches(String contentTypeToMatch) {
        for (String contentType : this.contentTypes) {
            if (!contentTypeToMatch.equalsIgnoreCase(contentType)) continue;
            return true;
        }
        return false;
    }

    public static Optional<MimeType> byContentType(String contentType) {
        if (contentType == null) {
            return Optional.empty();
        }
        return Stream.of(MimeType.values()).filter(mt -> mt.matches(contentType)).findFirst();
    }

    public String[] getContentTypes() {
        return this.contentTypes;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

