/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v1Tag;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.ID3v24Tag;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.Mp3File;
import com.mpatric.mp3agic.NotSupportedException;
import com.mpatric.mp3agic.UnsupportedTagException;
import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.ConsoleMetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.MetaDataConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.MimeType;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.CopyOption;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopyConsumer
extends MetaDataConsumer
implements Consumer<HttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(StreamCopyConsumer.class);
    private final long creationTimeStamp;
    private int fileNumber;
    private MetaData metaData;
    private MetaData previousMetaData;
    private boolean metaDataChanged;
    private final File directory;
    private Optional<File> file = Optional.empty();
    private Optional<FileOutputStream> outputStream = Optional.empty();

    public StreamCopyConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
        this.creationTimeStamp = System.currentTimeMillis();
        this.directory = this.createDirectory(consumerContext);
        try {
            this.initFileNumber();
        }
        catch (IOException ex) {
            log.warn("File number finding problem", (Throwable)ex);
            this.fileNumber = 1;
        }
    }

    private File createDirectory(ConsumerContext context) {
        String hostAndPath;
        File parent = context.getTargetDirectory();
        try {
            hostAndPath = URLEncoder.encode(context.getRadio().getName(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        File dir = new File(parent, hostAndPath);
        dir.mkdirs();
        return dir;
    }

    private boolean needToAbort(Optional<File> currentFile) throws IOException {
        if (currentFile.isPresent()) {
            long required;
            FileStore fileStore;
            long free;
            File f = currentFile.get();
            if (this.getContext().getAbortAfterFileLength().isPresent() && f.length() > this.getContext().getAbortAfterFileLength().get()) {
                log.warn("Aborting due to maximum file size of {} exceeded: {} file size, {} is the abort-after size", new Object[]{f, f.length(), this.getContext().getAbortAfterFileLength().get()});
                return true;
            }
            if (this.getContext().getAbortAfterDuration().isPresent()) {
                long abortAfterMillis = this.getContext().getAbortAfterDuration().get();
                long elapsedMillis = System.currentTimeMillis() - this.creationTimeStamp;
                if (elapsedMillis > abortAfterMillis) {
                    log.warn("Aborting due to maximum duration of {}ms", (Object)(System.currentTimeMillis() - this.creationTimeStamp));
                    return true;
                }
            }
            if ((free = (fileStore = Files.getFileStore(f.toPath())).getUsableSpace()) < (required = this.getContext().getMinFree())) {
                log.warn("Path {} is too full, has less than {} bytes free", (Object)f, (Object)required);
                return true;
            }
        }
        return false;
    }

    private void openUnnamedFileAndInputStream(Optional<MimeType> contentType) {
        File f = this.getNumberFile(contentType);
        this.file = Optional.of(f);
        try {
            this.outputStream = Optional.of(new FileOutputStream(f));
        }
        catch (FileNotFoundException ex) {
            throw new RadioException(false, (Throwable)ex);
        }
        log.debug("Copying from url {} to file {}, type {}", new Object[]{this.getContext().getUri().toASCIIString(), f, contentType});
    }

    private void closeOldFileAndReopenWithNewMetadata(Optional<MimeType> contentType) throws IOException {
        log.debug("Meta data changed");
        this.metaDataChanged = false;
        this.closeStreamIfOpen(this.outputStream, this.file, contentType);
        this.file = this.getFileFromMetaData(contentType);
        log.debug("New file {}", this.file);
        this.outputStream = this.file.isPresent() ? Optional.of(new FileOutputStream(this.file.get())) : Optional.empty();
    }

    @Override
    protected void __accept(HttpConnection t, InputStream inputStream) {
        Runnable cleanup = () -> this.cleanup(this.getContext().isSongNames());
        Thread cleanupThread = new Thread(cleanup);
        Runtime.getRuntime().addShutdownHook(cleanupThread);
        try {
            int len;
            this.getStreamMetaData().setMetaDataConsumer(m -> {
                this.previousMetaData = this.metaData;
                this.metaData = m;
                this.metaDataChanged = true;
                new ConsoleMetaDataConsumer().accept((MetaData)m);
            });
            byte[] buffer = new byte[8192];
            Optional<MimeType> contentType = MimeType.byContentType(t.getContentType());
            if (!this.getContext().isSongNames()) {
                this.openUnnamedFileAndInputStream(contentType);
            }
            long ofs = 0L;
            boolean dropMsgWritten = false;
            while (-1 != (len = inputStream.read(buffer))) {
                block17: {
                    try {
                        if (!this.needToAbort(this.file)) break block17;
                        return;
                    }
                    catch (IOException ioe) {
                        throw new RadioException(false, (Throwable)ioe);
                    }
                }
                if (this.metaDataChanged && this.getContext().isSongNames() && this.metaData.getIndex().orElse(0) > 0) {
                    this.closeOldFileAndReopenWithNewMetadata(contentType);
                }
                if (this.outputStream.isPresent()) {
                    this.outputStream.get().write(buffer, 0, len);
                } else {
                    if (!dropMsgWritten) {
                        if (this.metaData != null) {
                            log.info("Dropping bytes of incomplete title {}", (Object)this.metaData);
                        } else {
                            log.info("Dropping bytes, no file name yet");
                        }
                    }
                    dropMsgWritten = true;
                }
                log.trace("Copied {} bytes", (Object)(ofs += (long)len));
            }
        }
        catch (IOException ex) {
            log.warn("URL " + this.getContext().getUri().toASCIIString() + " broke down", (Throwable)ex);
            ++this.fileNumber;
            throw new RadioException(true, (Throwable)ex);
        }
        finally {
            this.cleanup(this.getContext().isSongNames());
            Runtime.getRuntime().removeShutdownHook(cleanupThread);
        }
    }

    private void cleanup(boolean deletePartly) {
        if (this.outputStream.isPresent()) {
            try {
                this.outputStream.get().close();
            }
            catch (IOException ex) {
                log.warn("URL " + this.getContext().getUri().toASCIIString() + " close error", (Throwable)ex);
            }
        }
        if (this.file.isPresent() && deletePartly) {
            log.info("Deleting partly file {}", (Object)this.file.get());
            this.file.get().delete();
        }
    }

    private void closeStreamIfOpen(Optional<FileOutputStream> outputStream, Optional<File> file, Optional<MimeType> contentType) throws IOException {
        MetaData fileMetaData;
        MetaData metaData = fileMetaData = this.previousMetaData != null ? this.previousMetaData.clone() : null;
        if (outputStream.isPresent()) {
            log.debug("Closing output stream to {}", file.orElse(null));
            outputStream.get().close();
            if (contentType.isPresent() && contentType.get() == MimeType.AUDIO_MPEG && file.isPresent() && fileMetaData != null) {
                Runnable r = () -> {
                    try {
                        this.addID3Tags(fileMetaData, (File)file.get());
                    }
                    catch (IOException ex) {
                        log.warn("Error while adding id3 tags", (Throwable)ex);
                    }
                };
                Thread t = new Thread(r, "ID3 " + file.get());
                t.start();
            }
            if (file.isPresent() && fileMetaData != null) {
                File f = file.get();
                Files.setLastModifiedTime(f.toPath(), FileTime.from(fileMetaData.getCreated().toInstant()));
            }
        }
    }

    private void addID3Tags(MetaData md, File file) throws IOException {
        try {
            log.debug("Adding id3 tag to {}", (Object)file);
            Mp3File mp3File = new Mp3File(file);
            ID3v1Tag id3v1 = new ID3v1Tag();
            md.getTitle().ifPresent(arg_0 -> ((ID3v1)id3v1).setTitle(arg_0));
            md.getArtist().ifPresent(arg_0 -> ((ID3v1)id3v1).setArtist(arg_0));
            md.getStationName().ifPresent(arg_0 -> ((ID3v1)id3v1).setComment(arg_0));
            mp3File.setId3v1Tag((ID3v1)id3v1);
            ID3v24Tag id3v2 = new ID3v24Tag();
            md.getTitle().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setTitle(arg_0));
            md.getArtist().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setArtist(arg_0));
            md.getStationName().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setPublisher(arg_0));
            md.getStationUrl().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setRadiostationUrl(arg_0));
            id3v2.setComment("Radio Recorder");
            id3v2.setUrl("https://github.com/sfuhrm/radiorecorder");
            mp3File.setId3v2Tag((ID3v2)id3v2);
            File bak = new File(file.getParentFile(), file.getName() + ".bak");
            File tmp = new File(file.getParentFile(), file.getName() + ".tmp");
            mp3File.save(tmp.getAbsolutePath());
            Files.move(file.toPath(), bak.toPath(), new CopyOption[0]);
            Files.move(tmp.toPath(), file.toPath(), new CopyOption[0]);
            Files.delete(bak.toPath());
            log.debug("Done adding id3 tag to {}", (Object)file);
        }
        catch (InvalidDataException | NotSupportedException | UnsupportedTagException ex) {
            log.warn("Exception while writing id3 tag for " + file, ex);
        }
    }

    private void initFileNumber() throws IOException {
        Pattern integerPattern = Pattern.compile("[0-9]+");
        try (Stream<Path> stream = Files.list(this.directory.toPath());){
            OptionalInt maxFileNumber = stream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(p -> p.getFileName().toString()).filter(s -> s.contains(".")).map(s -> s.substring(0, s.indexOf(46))).filter(s -> integerPattern.matcher((CharSequence)s).matches()).mapToInt(Integer::parseInt).max();
            this.fileNumber = maxFileNumber.orElse(0) + 1;
            log.debug("Found file number {}, fileNumber starts at {}", (Object)maxFileNumber, (Object)this.fileNumber);
        }
    }

    private File getNumberFile(Optional<MimeType> contentType) {
        File f;
        do {
            String fileName = String.format("%03d%s", this.fileNumber, StreamCopyConsumer.suffixFromContentType(contentType));
            f = new File(this.directory, fileName);
            ++this.fileNumber;
        } while (f.exists() && f.length() != 0L);
        return f;
    }

    private Optional<File> getFileFromMetaData(Optional<MimeType> contentType) {
        Optional<File> result = Optional.empty();
        if (this.metaData != null) {
            String unknown;
            String fileName;
            File file;
            do {
                unknown = "unknown";
            } while ((file = new File(this.directory, fileName = String.format("%03d.%s - %s%s", this.fileNumber++, StreamCopyConsumer.sanitizeFileName(this.metaData.getArtist().orElse(unknown)), StreamCopyConsumer.sanitizeFileName(this.metaData.getTitle().orElse(unknown)), StreamCopyConsumer.suffixFromContentType(contentType)))).exists() && file.length() != 0L);
            result = Optional.of(file);
        }
        return result;
    }

    private static String sanitizeFileName(String in) {
        return in.replaceAll("[/:\\|]", "_");
    }

    private static String suffixFromContentType(Optional<MimeType> contentType) {
        if (!contentType.isPresent()) {
            return "";
        }
        return contentType.get().getSuffix();
    }
}

