/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import su.litvak.chromecast.api.v2.AppEvent;
import su.litvak.chromecast.api.v2.ChromeCastConnectionEvent;
import su.litvak.chromecast.api.v2.ChromeCastConnectionEventListener;
import su.litvak.chromecast.api.v2.ChromeCastSpontaneousEvent;
import su.litvak.chromecast.api.v2.ChromeCastSpontaneousEventListener;
import su.litvak.chromecast.api.v2.JacksonHelper;
import su.litvak.chromecast.api.v2.MediaStatus;
import su.litvak.chromecast.api.v2.StandardResponse;

class EventListenerHolder
implements ChromeCastSpontaneousEventListener,
ChromeCastConnectionEventListener {
    private final ObjectMapper jsonMapper = JacksonHelper.createJSONMapper();
    private final Set<ChromeCastSpontaneousEventListener> eventListeners = new CopyOnWriteArraySet<ChromeCastSpontaneousEventListener>();
    private final Set<ChromeCastConnectionEventListener> eventListenersConnection = new CopyOnWriteArraySet<ChromeCastConnectionEventListener>();

    EventListenerHolder() {
    }

    public void registerListener(ChromeCastSpontaneousEventListener listener) {
        if (listener != null) {
            this.eventListeners.add(listener);
        }
    }

    public void unregisterListener(ChromeCastSpontaneousEventListener listener) {
        if (listener != null) {
            this.eventListeners.remove(listener);
        }
    }

    public void deliverEvent(JsonNode json) throws IOException {
        StandardResponse resp;
        if (json == null || this.eventListeners.isEmpty()) {
            return;
        }
        if (json.has("responseType")) {
            try {
                resp = (StandardResponse)this.jsonMapper.treeToValue((TreeNode)json, StandardResponse.class);
            }
            catch (JsonMappingException jme) {
                resp = null;
            }
        } else {
            resp = null;
        }
        if (resp instanceof StandardResponse.MediaStatus) {
            StandardResponse.MediaStatus mediaStatusResponse = (StandardResponse.MediaStatus)resp;
            if (mediaStatusResponse.statuses == null) {
                if (json.has("media")) {
                    try {
                        MediaStatus ms = (MediaStatus)this.jsonMapper.treeToValue((TreeNode)json, MediaStatus.class);
                        this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.MEDIA_STATUS, ms));
                    }
                    catch (JsonMappingException jsonMappingException) {}
                }
            } else {
                for (MediaStatus ms : mediaStatusResponse.statuses) {
                    this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.MEDIA_STATUS, ms));
                }
            }
        } else if (resp instanceof StandardResponse.Status) {
            this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.STATUS, ((StandardResponse.Status)resp).status));
        } else if (resp instanceof StandardResponse.Close) {
            this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.CLOSE, new Object()));
        } else {
            this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.UNKNOWN, json));
        }
    }

    public void deliverAppEvent(AppEvent event) throws IOException {
        this.spontaneousEventReceived(new ChromeCastSpontaneousEvent(ChromeCastSpontaneousEvent.SpontaneousEventType.APPEVENT, event));
    }

    @Override
    public void spontaneousEventReceived(ChromeCastSpontaneousEvent event) {
        for (ChromeCastSpontaneousEventListener listener : this.eventListeners) {
            listener.spontaneousEventReceived(event);
        }
    }

    public void registerConnectionListener(ChromeCastConnectionEventListener listener) {
        if (listener != null) {
            this.eventListenersConnection.add(listener);
        }
    }

    public void unregisterConnectionListener(ChromeCastConnectionEventListener listener) {
        if (listener != null) {
            this.eventListenersConnection.remove(listener);
        }
    }

    public void deliverConnectionEvent(boolean connected) {
        this.connectionEventReceived(new ChromeCastConnectionEvent(connected));
    }

    @Override
    public void connectionEventReceived(ChromeCastConnectionEvent event) {
        for (ChromeCastConnectionEventListener listener : this.eventListenersConnection) {
            listener.connectionEventReceived(event);
        }
    }
}

