/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiobrowser4j.Station;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Radio {
    private static final Logger log = LoggerFactory.getLogger(Radio.class);
    private String name;
    private URL url;
    private UUID uuid;
    private URL favIconUrl;
    private String codec;
    private int bitrate;
    private List<String> tags = Collections.emptyList();

    static Radio fromStation(Station s) {
        Radio r = new Radio();
        r.setName(s.getName());
        if (s.getUrl() != null) {
            try {
                r.setUrl(new URL(s.getUrl()));
            }
            catch (MalformedURLException e) {
                log.error("Error parsing station URL '" + s.getUrl() + "'", (Throwable)e);
                throw new IllegalArgumentException(e);
            }
        }
        r.setUuid(s.getStationUUID());
        if (s.getFavicon() != null && !s.getFavicon().isEmpty()) {
            try {
                r.setFavIconUrl(new URL(s.getFavicon()));
            }
            catch (MalformedURLException e) {
                log.warn("Error parsing station favicon URL '" + s.getFavicon() + "'", (Throwable)e);
            }
        }
        r.setCodec(s.getCodec());
        r.setBitrate(r.getBitrate());
        r.setTags(new ArrayList<String>(r.getTags()));
        return r;
    }

    public String getName() {
        return this.name;
    }

    public URL getUrl() {
        return this.url;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public URL getFavIconUrl() {
        return this.favIconUrl;
    }

    public String getCodec() {
        return this.codec;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public void setFavIconUrl(URL favIconUrl) {
        this.favIconUrl = favIconUrl;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    public String toString() {
        return "Radio(name=" + this.getName() + ", url=" + this.getUrl() + ", uuid=" + this.getUuid() + ", favIconUrl=" + this.getFavIconUrl() + ", codec=" + this.getCodec() + ", bitrate=" + this.getBitrate() + ", tags=" + this.getTags() + ")";
    }
}

