/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.databind.JsonNode;
import su.litvak.chromecast.api.v2.AppEvent;
import su.litvak.chromecast.api.v2.MediaStatus;
import su.litvak.chromecast.api.v2.Status;

public class ChromeCastSpontaneousEvent {
    private final SpontaneousEventType type;
    private final Object data;

    public ChromeCastSpontaneousEvent(SpontaneousEventType type, Object data) {
        if (!type.getDataClass().isAssignableFrom(data.getClass())) {
            throw new IllegalArgumentException("Data type " + data.getClass() + " does not match type for event " + type.getDataClass());
        }
        this.type = type;
        this.data = data;
    }

    public final SpontaneousEventType getType() {
        return this.type;
    }

    public final Object getData() {
        return this.data;
    }

    public final <T> T getData(Class<T> cls) {
        if (!cls.isAssignableFrom(this.type.getDataClass())) {
            throw new IllegalArgumentException("Requested type " + cls + " does not match type for event " + this.type.getDataClass());
        }
        return cls.cast(this.data);
    }

    public static enum SpontaneousEventType {
        MEDIA_STATUS(MediaStatus.class),
        STATUS(Status.class),
        APPEVENT(AppEvent.class),
        CLOSE(Object.class),
        UNKNOWN(JsonNode.class);

        private final Class<?> dataClass;

        private SpontaneousEventType(Class<?> dataClass) {
            this.dataClass = dataClass;
        }

        public Class<?> getDataClass() {
            return this.dataClass;
        }
    }
}

