/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.AbstractHttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.JavaNetHttpConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaNetHttpConnectionBuilder
extends AbstractHttpConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(JavaNetHttpConnectionBuilder.class);
    private final URL url;

    JavaNetHttpConnectionBuilder(URL url) {
        this.url = url;
    }

    @Override
    public HttpConnection build() throws IOException {
        Proxy proxyToUse = Proxy.NO_PROXY;
        if (this.proxy.isPresent()) {
            proxyToUse = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(((URL)this.proxy.get()).getHost(), ((URL)this.proxy.get()).getPort()));
        }
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection(proxyToUse);
        if (this.readTimeout.isPresent()) {
            connection.setReadTimeout((Integer)this.readTimeout.get());
        }
        if (this.connectTimeout.isPresent()) {
            connection.setConnectTimeout((Integer)this.connectTimeout.get());
        }
        if (!this.requestProperties.isEmpty()) {
            this.requestProperties.forEach(connection::setRequestProperty);
        }
        return new JavaNetHttpConnection(connection);
    }
}

