/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import su.litvak.chromecast.api.v2.Media;
import su.litvak.chromecast.api.v2.Request;
import su.litvak.chromecast.api.v2.StandardMessage;
import su.litvak.chromecast.api.v2.Volume;

abstract class StandardRequest
extends StandardMessage
implements Request {
    Long requestId;

    StandardRequest() {
    }

    @Override
    public final void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    @Override
    public final Long getRequestId() {
        return this.requestId;
    }

    static Status status() {
        return new Status();
    }

    static AppAvailability appAvailability(String ... appId) {
        return new AppAvailability(appId);
    }

    static Launch launch(String appId) {
        return new Launch(appId);
    }

    static Stop stop(String sessionId) {
        return new Stop(sessionId);
    }

    static Load load(String sessionId, Media media, boolean autoplay, double currentTime, Map<String, String> customData) {
        return new Load(sessionId, media, autoplay, currentTime, customData);
    }

    static Play play(String sessionId, long mediaSessionId) {
        return new Play(mediaSessionId, sessionId);
    }

    static Pause pause(String sessionId, long mediaSessionId) {
        return new Pause(mediaSessionId, sessionId);
    }

    static Seek seek(String sessionId, long mediaSessionId, double currentTime) {
        return new Seek(mediaSessionId, sessionId, currentTime);
    }

    static SetVolume setVolume(Volume volume) {
        return new SetVolume(volume);
    }

    static class SetVolume
    extends StandardRequest {
        @JsonProperty
        final Volume volume;

        SetVolume(Volume volume) {
            this.volume = volume;
        }
    }

    static class Seek
    extends MediaRequest {
        @JsonProperty
        final double currentTime;

        Seek(long mediaSessionId, String sessionId, double currentTime) {
            super(mediaSessionId, sessionId);
            this.currentTime = currentTime;
        }
    }

    static class Pause
    extends MediaRequest {
        Pause(long mediaSessionId, String sessionId) {
            super(mediaSessionId, sessionId);
        }
    }

    static class Play
    extends MediaRequest {
        Play(long mediaSessionId, String sessionId) {
            super(mediaSessionId, sessionId);
        }
    }

    static abstract class MediaRequest
    extends StandardRequest {
        @JsonProperty
        final long mediaSessionId;
        @JsonProperty
        final String sessionId;

        MediaRequest(long mediaSessionId, String sessionId) {
            this.mediaSessionId = mediaSessionId;
            this.sessionId = sessionId;
        }
    }

    static class Load
    extends StandardRequest {
        @JsonProperty
        final String sessionId;
        @JsonProperty
        final Media media;
        @JsonProperty
        final boolean autoplay;
        @JsonProperty
        final double currentTime;
        @JsonProperty
        final Object customData;

        Load(String sessionId, Media media, boolean autoplay, double currentTime, final Map<String, String> customData) {
            this.sessionId = sessionId;
            this.media = media;
            this.autoplay = autoplay;
            this.currentTime = currentTime;
            this.customData = customData == null ? null : new Object(){
                @JsonProperty
                Map<String, String> payload;
                {
                    this.payload = customData;
                }
            };
        }
    }

    static class Stop
    extends StandardRequest {
        @JsonProperty
        final String sessionId;

        Stop(String sessionId) {
            this.sessionId = sessionId;
        }
    }

    static class Launch
    extends StandardRequest {
        @JsonProperty
        final String appId;

        Launch(@JsonProperty(value="appId") String appId) {
            this.appId = appId;
        }
    }

    static class AppAvailability
    extends StandardRequest {
        @JsonProperty
        final String[] appId;

        AppAvailability(String ... appId) {
            this.appId = appId;
        }
    }

    static class Status
    extends StandardRequest {
        Status() {
        }
    }
}

