/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.Main;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilderFactory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Params {
    private static final Logger log = LoggerFactory.getLogger(Params.class);
    @Option(name="-help", aliases={"-h"}, usage="Show this command line help.", help=true)
    private boolean help;
    @Option(name="-directory", aliases={"-d"}, usage="Write recorded stream files to a folder hierarchy in this target directory.", metaVar="DIR")
    private File directory;
    @Option(name="-use-songnames", aliases={"-S"}, usage="Use songnames from retrieved metadata information. Will create one file per detected song.")
    private boolean songNames;
    @Option(name="-limit", aliases={"-l"}, usage="Limit of stations to download in parallel.", metaVar="COUNT")
    private int stationLimit = 10;
    @Option(name="-min-free", aliases={"-M"}, usage="Minimum of free megs on target drive.", metaVar="MEGS")
    private long minimumFreeMegs = 512L;
    @Option(name="-abort-after", usage="Abort after writing the given amount of kilobytes to target drive.", metaVar="KB")
    private Long abortAfterKilo;
    @Option(name="-reconnect", aliases={"-r"}, usage="Automatically reconnect after connection loss.")
    private boolean reconnect;
    @Option(name="-play", aliases={"-p"}, usage="Play live instead of recording to a file.")
    private boolean play;
    @Option(name="-version", aliases={"-V"}, usage="Show version information and exit.", help=true)
    private boolean version;
    @Option(name="-mixer", aliases={"-m"}, usage="The mixer to use for playback. The mixer parameter is the name from the '-list-mixer' option output.", metaVar="MIXER_NAME")
    private String mixer;
    @Option(name="-list-mixer", aliases={"-X"}, usage="List audio playback mixers, then exit.", help=true)
    private boolean listMixers;
    @Option(name="-list-cast", aliases={"-L"}, usage="List chromecast devices, then exit.", help=true)
    private boolean listCast;
    @Option(name="-list-station", aliases={"-Z"}, usage="List matching radio stations limited by '-limit', then exit.", help=true)
    private boolean listStation;
    @Option(name="-cast", aliases={"-c"}, usage="Stream to the given chrome cast device. Use cast device title from '-list-cast'.", metaVar="CASTDEVICE_TITLE")
    private String castReceiver;
    @Option(name="-timeout", aliases={"-T"}, usage="Connect/read timeout in seconds.", metaVar="SECS")
    private int timeout = 60;
    @Option(name="-client", aliases={"-C"}, usage="Specify HTTP client to use.", metaVar="CLIENT")
    private HttpConnectionBuilderFactory.HttpClientType httpClientType = HttpConnectionBuilderFactory.HttpClientType.APACHE_CLIENT_5;
    @Option(name="-proxy", aliases={"-P"}, usage="The HTTP/HTTPS proxy to use.", metaVar="URL")
    private URL proxy;
    @Argument(usage="URLs of the internet radio station(s), (partial) station name for lookup or the station UUID (see option -list-station)", metaVar="URL_OR_UUID_OR_NAME", required=true)
    private List<String> arguments;

    public static Params parse(String[] args) {
        CmdLineParser cmdLineParser = null;
        try {
            boolean isList;
            if (log.isDebugEnabled()) {
                log.debug("Args: {}", (Object)Arrays.toString(args));
            }
            Params result = new Params();
            cmdLineParser = new CmdLineParser((Object)result);
            cmdLineParser.parseArgument(args);
            if (result.help) {
                cmdLineParser.printUsage((OutputStream)System.err);
                return null;
            }
            if (result.isVersion()) {
                result.showVersion();
                return null;
            }
            boolean bl = isList = result.isListCast() || result.isListStation() || result.isListMixers();
            if (!result.isPlay() && !isList && result.getDirectory() == null) {
                cmdLineParser.printUsage((OutputStream)System.err);
                log.error("Not playing, need a target directory (-directory)!");
                return null;
            }
            if (result.getDirectory() != null && Params.prepareOutputDirectory(cmdLineParser, result.getDirectory().toPath())) {
                return null;
            }
            return result;
        }
        catch (CmdLineException ex) {
            log.warn("Error in parsing", (Throwable)ex);
            cmdLineParser.printUsage((OutputStream)System.err);
        }
        catch (IOException e) {
            log.error("Error in program", (Throwable)e);
        }
        return null;
    }

    private static boolean prepareOutputDirectory(CmdLineParser cmdLineParser, Path directoryPath) throws IOException {
        if (!Files.exists(directoryPath, new LinkOption[0])) {
            log.info("Target directory {} not existing, creating.", (Object)directoryPath);
            Files.createDirectories(directoryPath, new FileAttribute[0]);
        }
        if (Files.isDirectory(directoryPath, new LinkOption[0]) && !Files.isWritable(directoryPath)) {
            cmdLineParser.printUsage((OutputStream)System.err);
            log.error("Target directory {} given, but it is not writable!", (Object)directoryPath);
            return true;
        }
        return false;
    }

    private void showVersion() throws IOException {
        try (InputStream inputStream = Main.class.getResourceAsStream("/application.properties");){
            Properties applicationProperties = new Properties();
            if (inputStream != null) {
                applicationProperties.load(inputStream);
            }
            String unknown = "unknown";
            System.err.printf("Application:  %s%n", applicationProperties.getOrDefault((Object)"application.name", unknown));
            System.err.printf("Version:      %s%n", applicationProperties.getOrDefault((Object)"application.version", unknown));
            System.err.printf("Build date:   %s%n", applicationProperties.getOrDefault((Object)"build.timestamp", unknown));
        }
    }

    public boolean isHelp() {
        return this.help;
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean isSongNames() {
        return this.songNames;
    }

    public int getStationLimit() {
        return this.stationLimit;
    }

    public long getMinimumFreeMegs() {
        return this.minimumFreeMegs;
    }

    public Long getAbortAfterKilo() {
        return this.abortAfterKilo;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public boolean isPlay() {
        return this.play;
    }

    public boolean isVersion() {
        return this.version;
    }

    public String getMixer() {
        return this.mixer;
    }

    public boolean isListMixers() {
        return this.listMixers;
    }

    public boolean isListCast() {
        return this.listCast;
    }

    public boolean isListStation() {
        return this.listStation;
    }

    public String getCastReceiver() {
        return this.castReceiver;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public HttpConnectionBuilderFactory.HttpClientType getHttpClientType() {
        return this.httpClientType;
    }

    public URL getProxy() {
        return this.proxy;
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

