/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.IcyMetaFilterStream;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.OffsetFilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMetaData {
    private static final Logger log = LoggerFactory.getLogger(StreamMetaData.class);
    private OffsetFilterStream offsetFilterStream;
    private IcyMetaFilterStream icyMetaFilterStream;
    private static final String ICY_METAINT = "icy-metaint";
    private static final String ICY_NAME = "icy-name";
    private static final String ICY_URL = "icy-url";
    private Consumer<MetaData> metaDataConsumer = l -> {};
    private MetaData metaData = new MetaData();

    public InputStream openStream(HttpConnection connection) throws IOException {
        OffsetFilterStream result = this.offsetFilterStream = new OffsetFilterStream(connection.getInputStream());
        Map<String, List<String>> headersOriginal = connection.getHeaderFields();
        Map<String, List> headers = headersOriginal.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), e -> (List)e.getValue()));
        if (headers.containsKey(ICY_NAME)) {
            this.metaData.setStationName(Optional.of((String)headers.get(ICY_NAME).get(0)));
        }
        if (headers.containsKey(ICY_URL)) {
            this.metaData.setStationUrl(Optional.of((String)headers.get(ICY_URL).get(0)));
        }
        if (headers.containsKey(ICY_METAINT)) {
            log.debug("Found Icy Meta Interval header: {}", (Object)headers.containsKey(ICY_METAINT));
            int metaInterval = Integer.parseInt((String)headers.get(ICY_METAINT).get(0));
            this.icyMetaFilterStream = new IcyMetaFilterStream(metaInterval, this.offsetFilterStream);
            this.icyMetaFilterStream.setMetaDataConsumer((String md) -> {
                Pattern p = Pattern.compile("(.{2,}) - (.{2,})");
                Matcher m = p.matcher((CharSequence)md);
                MetaData target = this.metaData.clone();
                target.setCreated(ZonedDateTime.now());
                target.setPosition(Optional.of(this.offsetFilterStream.getOffset()));
                if (m.matches()) {
                    String artist = m.group(1);
                    String title = m.group(2);
                    log.debug("Icy Meta artist: {}, icy meta title: {}", (Object)artist, (Object)title);
                    target.setArtist(Optional.of(artist));
                    target.setTitle(Optional.of(title));
                } else {
                    log.info("Icy Meta data was malformed: {}", md);
                    target.setArtist(Optional.empty());
                    target.setTitle(Optional.empty());
                }
                this.metaData = target;
                this.metaDataConsumer.accept(target);
            });
            result = this.icyMetaFilterStream;
        }
        return result;
    }

    public Consumer<MetaData> getMetaDataConsumer() {
        return this.metaDataConsumer;
    }

    public void setMetaDataConsumer(Consumer<MetaData> metaDataConsumer) {
        this.metaDataConsumer = metaDataConsumer;
    }
}

