/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

class ListHelper<T> {
    private List<T> list;
    private List<ColumnInfo> columns;

    ListHelper(List<T> inList) {
        this.list = new ArrayList<T>(inList);
        this.columns = new ArrayList<ColumnInfo>();
    }

    void addColumn(String name, Function<T, String> formatter) {
        this.columns.add(new ColumnInfo(this.columns.size(), name, formatter, name.length()));
    }

    private void calculateSizes() {
        for (T item : this.list) {
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.maxLength = Math.max(columnInfo.maxLength, ((String)columnInfo.formatter.apply(item)).length());
            }
        }
    }

    String fill(String in, int length) {
        StringBuilder sb = new StringBuilder(in);
        while (sb.length() < length) {
            sb.append(' ');
        }
        return sb.toString();
    }

    void print(PrintStream ps) {
        this.calculateSizes();
        for (ColumnInfo columnInfo : this.columns) {
            ps.print(this.fill(columnInfo.name, columnInfo.maxLength));
            ps.print(' ');
        }
        ps.print("\n");
        for (ColumnInfo item : this.list) {
            for (ColumnInfo columnInfo : this.columns) {
                ps.print(this.fill((String)columnInfo.formatter.apply(item), columnInfo.maxLength));
                ps.print(' ');
            }
            ps.print("\n");
        }
    }

    private class ColumnInfo {
        int index;
        private String name;
        private Function<T, String> formatter;
        int maxLength;

        public int getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Function<T, String> getFormatter() {
            return this.formatter;
        }

        public int getMaxLength() {
            return this.maxLength;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setFormatter(Function<T, String> formatter) {
            this.formatter = formatter;
        }

        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        public ColumnInfo(int index, String name, Function<T, String> formatter, int maxLength) {
            this.index = index;
            this.name = name;
            this.formatter = formatter;
            this.maxLength = maxLength;
        }
    }
}

