/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.IcyMetaFilterStream;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.OffsetFilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMetaData {
    private static final Logger log = LoggerFactory.getLogger(StreamMetaData.class);
    private OffsetFilterStream offsetFilterStream;
    private IcyMetaFilterStream icyMetaFilterStream;
    private static final String ICY_METAINT = "icy-metaint";
    private static final String ICY_NAME = "icy-name";
    private static final String ICY_URL = "icy-url";
    private Consumer<MetaData> metaDataConsumer = l -> {};
    private MetaData metaData = new MetaData();

    public InputStream openStream(HttpConnection connection) throws IOException {
        OffsetFilterStream result = this.offsetFilterStream = new OffsetFilterStream(connection.getInputStream());
        Map<String, List<String>> headers = connection.getHeaderFields();
        if (headers.containsKey(ICY_NAME)) {
            this.metaData.setStationName(Optional.of(headers.get(ICY_NAME).get(0)));
        }
        if (headers.containsKey(ICY_URL)) {
            this.metaData.setStationUrl(Optional.of(headers.get(ICY_URL).get(0)));
        }
        if (headers.containsKey(ICY_METAINT)) {
            log.debug("Found Icy Meta Interval header: {}", (Object)headers.containsKey(ICY_METAINT));
            int metaInterval = Integer.parseInt(headers.get(ICY_METAINT).get(0));
            this.icyMetaFilterStream = new IcyMetaFilterStream(metaInterval, this.offsetFilterStream);
            this.icyMetaFilterStream.setMetaDataConsumer((String md) -> {
                Pattern p = Pattern.compile("(.{2,}) - (.{2,})");
                Matcher m = p.matcher((CharSequence)md);
                MetaData target = this.metaData.clone();
                target.setCreated(ZonedDateTime.now());
                target.setPosition(Optional.of(this.offsetFilterStream.getOffset()));
                if (m.matches()) {
                    target.setArtist(Optional.of(m.group(1)));
                    target.setTitle(Optional.of(m.group(2)));
                } else {
                    target.setArtist(Optional.empty());
                    target.setTitle(Optional.empty());
                }
                this.metaData = target;
                this.metaDataConsumer.accept(target);
            });
            result = this.icyMetaFilterStream;
        }
        return result;
    }

    public Consumer<MetaData> getMetaDataConsumer() {
        return this.metaDataConsumer;
    }

    public void setMetaDataConsumer(Consumer<MetaData> metaDataConsumer) {
        this.metaDataConsumer = metaDataConsumer;
    }
}

