/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.AbstractConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.StreamMetaData;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetaDataConsumer
extends AbstractConsumer
implements Consumer<HttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(MetaDataConsumer.class);
    private final StreamMetaData streamMetaData = new StreamMetaData();

    public MetaDataConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
    }

    @Override
    protected final void _accept(HttpConnection t) {
        try {
            InputStream inputStream = this.streamMetaData.openStream(t);
            this.__accept(t, inputStream);
        }
        catch (IOException ex) {
            log.warn("Failed to open", (Throwable)ex);
            throw new RadioException(true, (Throwable)ex);
        }
    }

    protected abstract void __accept(HttpConnection var1, InputStream var2);

    public StreamMetaData getStreamMetaData() {
        return this.streamMetaData;
    }
}

