/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.impl.client.CloseableHttpClient;

class ApacheHttpClient4Connection
implements HttpConnection {
    private final CloseableHttpClient client;
    private final CloseableHttpResponse response;
    private final URI uri;

    ApacheHttpClient4Connection(CloseableHttpClient client, CloseableHttpResponse connection, URI uri) {
        this.client = client;
        this.response = connection;
        this.uri = uri;
    }

    @Override
    public URL getURL() throws IOException {
        return this.uri.toURL();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return Stream.of(this.response.getAllHeaders()).filter(h -> h.getValue() != null).collect(Collectors.groupingBy(NameValuePair::getName, Collectors.mapping(NameValuePair::getValue, Collectors.toList())));
    }

    @Override
    public InputStream getInputStream() throws IOException {
        HttpEntity entity = this.response.getEntity();
        return entity.getContent();
    }

    @Override
    public String getContentType() {
        return this.response.getFirstHeader("Content-Type").getValue();
    }

    @Override
    public int getResponseCode() {
        return this.response.getStatusLine().getStatusCode();
    }

    @Override
    public String getResponseMessage() {
        return this.response.getStatusLine().getReasonPhrase();
    }

    @Override
    public void close() throws IOException {
        this.response.close();
        this.client.close();
    }
}

