/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.Params;
import de.sfuhrm.radiorecorder.Radio;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilderFactory;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsumerContext {
    private static final Logger log = LoggerFactory.getLogger(ConsumerContext.class);
    private final int id;
    private final Radio radio;
    private final URL url;
    private final Params params;

    public ConsumerContext(int id, Radio radio, Params params) throws MalformedURLException {
        this.id = id;
        this.radio = radio;
        this.url = radio.getUrl();
        this.params = Objects.requireNonNull(params);
    }

    public int getTimeout() {
        return this.params.getTimeout() * 1000;
    }

    public File getTargetDirectory() {
        return this.params.getDirectory();
    }

    public long getMinFree() {
        return this.params.getMinimumFreeMegs() * 1024L * 1024L;
    }

    public Optional<Long> getAbortAfter() {
        if (this.params.getAbortAfterKilo() == null) {
            return Optional.empty();
        }
        return Optional.of(this.params.getAbortAfterKilo() * 1024L);
    }

    public boolean isPlaying() {
        return this.params.isPlay();
    }

    public boolean isSongNames() {
        return this.params.isSongNames();
    }

    public boolean isReconnect() {
        return this.params.isReconnect();
    }

    public String getCastReceiver() {
        return this.params.getCastReceiver();
    }

    public Mixer.Info getMixerInfo() {
        if (this.params.getMixer() != null) {
            Optional<Mixer.Info> optionalInfo = Arrays.stream(AudioSystem.getMixerInfo()).filter(mi -> mi.getName().equals(this.params.getMixer())).findFirst();
            if (optionalInfo.isPresent()) {
                return optionalInfo.get();
            }
            log.warn("No mixer info for command line mixer argument: {}. Falling back to default.", (Object)this.params.getMixer());
        }
        return null;
    }

    public HttpConnectionBuilderFactory.HttpClientType getHttpClient() {
        return this.params.getHttpClientType();
    }

    public URL getProxy() {
        return this.params.getProxy();
    }

    public int getId() {
        return this.id;
    }

    public Radio getRadio() {
        return this.radio;
    }

    public URL getUrl() {
        return this.url;
    }
}

