/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import de.sfuhrm.radiorecorder.metadata.OffsetFilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IcyMetaFilterStream
extends OffsetFilterStream {
    private static final Logger log = LoggerFactory.getLogger(IcyMetaFilterStream.class);
    private final int metaInterval;
    private final Pattern streamTitlePattern;
    private final Pattern streamUrlPattern;
    private String lastMetaData;
    private Consumer<String> metaDataConsumer = t -> {};

    IcyMetaFilterStream(int icyMetaInterval, InputStream inputStream) {
        super(inputStream);
        this.metaInterval = icyMetaInterval;
        this.streamTitlePattern = Pattern.compile("StreamTitle='(([^']|('[^;]))*)';");
        this.streamUrlPattern = Pattern.compile("StreamURL='(([^']|('[^;]))*)';");
    }

    private static int indexOf(byte[] array, byte findMe) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != findMe) continue;
            return i;
        }
        return -1;
    }

    private void readIcyMeta() throws IOException {
        log.trace("Offset is {}, Icy Interval is {}", (Object)this.getOffset(), (Object)this.metaInterval);
        int c = super.read();
        int length = (c & 0xFF) * 16;
        byte[] metaData = new byte[length];
        int actually = super.read(metaData, 0, length);
        log.trace("Expected len {}, actual len {}", (Object)length, (Object)actually);
        int firstZero = IcyMetaFilterStream.indexOf(metaData, (byte)0);
        int stringLen = firstZero != -1 ? firstZero : length;
        String meta = new String(metaData, 0, stringLen, StandardCharsets.UTF_8);
        Matcher matcher = this.streamTitlePattern.matcher(meta);
        if (matcher.find()) {
            String currentMetaData = matcher.group(1);
            if (!currentMetaData.equals(this.lastMetaData)) {
                this.metaDataConsumer.accept(currentMetaData);
            }
            this.lastMetaData = currentMetaData;
            log.debug("Found metadata: {}", (Object)this.lastMetaData);
        } else if (length != 0) {
            log.warn("No metadata found in stream, but had {} bytes (got: {})", (Object)length, (Object)meta);
        }
        matcher = this.streamUrlPattern.matcher(meta);
        if (matcher.find()) {
            String streamUrl = matcher.group(1);
            log.info("Stream URL: {}", (Object)streamUrl);
        }
        this.setOffset(0L);
    }

    @Override
    public int read() throws IOException {
        if (this.getOffset() == (long)this.metaInterval) {
            this.readIcyMeta();
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        if (this.getOffset() == (long)this.metaInterval) {
            this.readIcyMeta();
            result = super.read(b, off, len);
        } else {
            int next = (int)((long)this.metaInterval - this.getOffset() % (long)this.metaInterval);
            result = len < next ? super.read(b, off, len) : super.read(b, off, next);
        }
        return result;
    }

    public String getLastMetaData() {
        return this.lastMetaData;
    }

    public Consumer<String> getMetaDataConsumer() {
        return this.metaDataConsumer;
    }

    public void setMetaDataConsumer(Consumer<String> metaDataConsumer) {
        this.metaDataConsumer = metaDataConsumer;
    }
}

