/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AbstractHttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpConnectionBuilder.class);
    protected Optional<Integer> connectTimeout = Optional.empty();
    protected Optional<Integer> readTimeout = Optional.empty();
    protected Map<String, String> requestProperties = new HashMap<String, String>();
    protected Optional<URL> proxy = Optional.empty();

    AbstractHttpConnectionBuilder() {
    }

    public void setConnectTimeout(int timeout) {
        log.debug("Connect timeout: {}", (Object)timeout);
        this.connectTimeout = Optional.of(timeout);
    }

    public void setReadTimeout(int timeout) {
        log.debug("Read timeout: {}", (Object)timeout);
        this.readTimeout = Optional.of(timeout);
    }

    public void setRequestProperty(String key, String value) {
        log.debug("Request property: {} = {}", (Object)key, (Object)value);
        this.requestProperties.put(key, value);
    }

    public void setProxy(URL proxy) {
        log.debug("Proxy: {}", (Object)proxy.toExternalForm());
        this.proxy = Optional.of(proxy);
    }
}

