/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.ConsoleMetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.MetaDataConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamPlayConsumer
extends MetaDataConsumer
implements Consumer<HttpConnection> {
    private static final Logger log = LoggerFactory.getLogger(StreamPlayConsumer.class);

    public StreamPlayConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
    }

    @Override
    protected void __accept(HttpConnection t, InputStream inputStream) {
        try {
            this.getStreamMetaData().setMetaDataConsumer(new ConsoleMetaDataConsumer());
            byte[] buffer = new byte[8192];
            AudioFileFormat audioFileFormat = AudioSystem.getAudioFileFormat(t.getURL());
            AudioFormat targetFormat = new AudioFormat(44100.0f, 16, 2, true, true);
            AudioInputStream input = AudioSystem.getAudioInputStream(inputStream);
            AudioInputStream converted = AudioSystem.getAudioInputStream(targetFormat, input);
            Mixer.Info mixerInfo = this.getContext().getMixerInfo();
            try (SourceDataLine line = AudioSystem.getSourceDataLine(targetFormat, mixerInfo);){
                long bufferSize = line.getBufferSize();
                log.info("Streaming from url {} to line {}, format {}, buffer size {}", new Object[]{this.getContext().getUrl().toExternalForm(), line.getLineInfo().toString(), audioFileFormat, bufferSize});
                long ofs = 0L;
                line.open(targetFormat);
                try {
                    int len;
                    while (-1 != (len = converted.read(buffer))) {
                        log.trace("Read {} bytes", (Object)len);
                        ofs += (long)len;
                        if (!line.isRunning() && line.available() < len) {
                            log.debug("Starting line, not yet running, {} / {} available", (Object)line.available(), (Object)bufferSize);
                            line.start();
                        }
                        line.write(buffer, 0, len);
                        log.trace("Wrote {} bytes (total {})", (Object)len, (Object)ofs);
                    }
                }
                catch (IOException ioe) {
                    throw new RadioException(true, (Throwable)ioe);
                }
                line.stop();
            }
        }
        catch (IOException | LineUnavailableException | UnsupportedAudioFileException ex) {
            log.warn("URL " + this.getContext().getUrl().toExternalForm() + " broke down", (Throwable)ex);
            throw new RadioException(false, (Throwable)ex);
        }
    }
}

