/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import java.util.Optional;
import java.util.stream.Stream;

public enum MimeType {
    AUDIO_MPEG("audio/mpeg", ".mp3"),
    AUDIO_OGG("audio/ogg", ".ogg"),
    AUDIO_XWAV("audio/x-wav", ".wav"),
    AUDIO_XMSWMA("audio/x-ms-wma", ".wma"),
    AUDIO_MPEGURL("audio/mpegurl", ".m3u"),
    AUDIO_XMPEGURL("audio/x-mpegurl", ".m3u"),
    AUDIO_XSCPLS("audio/x-scpls", ".pls"),
    APPLICATION_OGG("application/ogg", ".ogg"),
    APPLICATION_PLS_XML("application/pls+xml", ".pls");

    private final String contentType;
    private final String suffix;

    private MimeType(String contentType, String suffix) {
        this.contentType = contentType;
        this.suffix = suffix;
    }

    public static Optional<MimeType> byContentType(String contentType) {
        if (contentType == null) {
            return Optional.empty();
        }
        return Stream.of(MimeType.values()).filter(mt -> mt.contentType.equalsIgnoreCase(contentType)).findFirst();
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getSuffix() {
        return this.suffix;
    }
}

