/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.Params;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilderFactory;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Mixer;

public class ConsumerContext {
    private final int id;
    private final URL url;
    private final File directory;
    private final Params params;

    public ConsumerContext(int id, URL url, File directory, Params params) {
        this.id = id;
        this.url = Objects.requireNonNull(url);
        this.directory = Objects.requireNonNull(directory);
        this.params = Objects.requireNonNull(params);
    }

    public int getTimeout() {
        return this.params.getTimeout() * 1000;
    }

    public long getMinFree() {
        return this.params.getMinimumFreeMegs() * 1024L * 1024L;
    }

    public Optional<Long> getAbortAfter() {
        if (this.params.getAbortAfterKilo() == null) {
            return Optional.empty();
        }
        return Optional.of(this.params.getAbortAfterKilo() * 1024L);
    }

    public boolean isPlaying() {
        return this.params.isPlay();
    }

    public boolean isSongNames() {
        return this.params.isSongNames();
    }

    public boolean isReconnect() {
        return this.params.isReconnect();
    }

    public String getCastReceiver() {
        return this.params.getCastReceiver();
    }

    public Mixer.Info getMixerInfo() {
        if (this.params.getMixer() != null) {
            Optional<Mixer.Info> optionalInfo = Arrays.stream(AudioSystem.getMixerInfo()).filter(mi -> mi.getName().equals(this.params.getMixer())).findFirst();
            if (optionalInfo.isPresent()) {
                return optionalInfo.get();
            }
            System.err.println("No mixer info " + this.params.getMixer());
        }
        return null;
    }

    public HttpConnectionBuilderFactory.HttpClientType getHttpClient() {
        return this.params.getHttpClientType();
    }

    public URL getProxy() {
        return this.params.getProxy();
    }

    public int getId() {
        return this.id;
    }

    public URL getUrl() {
        return this.url;
    }

    public File getDirectory() {
        return this.directory;
    }
}

