/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.JavaNetHttpConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JavaNetHttpConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(JavaNetHttpConnectionBuilder.class);
    private final URL url;
    private HttpURLConnection connection;

    JavaNetHttpConnectionBuilder(URL url) {
        this.url = url;
    }

    private HttpURLConnection connection() throws IOException {
        if (this.connection == null) {
            this.connection = (HttpURLConnection)this.url.openConnection();
        }
        return this.connection;
    }

    @Override
    public void setConnectTimeout(int timeout) throws IOException {
        log.debug("Connect timeout is {}", (Object)timeout);
        this.connection().setConnectTimeout(timeout);
    }

    @Override
    public void setReadTimeout(int timeout) throws IOException {
        log.debug("Read timeout is {}", (Object)timeout);
        this.connection().setReadTimeout(timeout);
    }

    @Override
    public void setRequestProperty(String key, String value) throws IOException {
        log.debug("Request property {} => {}", (Object)key, (Object)value);
        this.connection().setRequestProperty(key, value);
    }

    @Override
    public HttpConnection build() throws IOException {
        return new JavaNetHttpConnection(this.connection());
    }

    @Override
    public void close() {
        this.connection.disconnect();
    }
}

