/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.ApacheHttpClient5Connection;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClient5ConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient5ConnectionBuilder.class);
    private final RequestConfig.Builder configBuilder = RequestConfig.custom();
    private final ClassicRequestBuilder requestBuilder;

    ApacheHttpClient5ConnectionBuilder(URL url) throws URISyntaxException {
        this.requestBuilder = ClassicRequestBuilder.get((URI)url.toURI());
        log.debug("Request for uri {}", (Object)this.requestBuilder.getUri());
    }

    @Override
    public void setConnectTimeout(int timeout) {
        log.debug("Connect timeout is {}", (Object)timeout);
        this.configBuilder.setConnectTimeout(Timeout.ofMilliseconds((long)timeout));
        this.configBuilder.setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeout));
    }

    @Override
    public void setReadTimeout(int timeout) {
        log.debug("Read timeout is {}", (Object)timeout);
        this.configBuilder.setResponseTimeout(Timeout.ofMilliseconds((long)timeout));
    }

    @Override
    public void setRequestProperty(String key, String value) {
        log.debug("Request property {} => {}", (Object)key, (Object)value);
        this.requestBuilder.addHeader(key, value);
    }

    @Override
    public HttpConnection build() throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(this.configBuilder.build()).build();
        return new ApacheHttpClient5Connection(client, client.execute(this.requestBuilder.build()), this.requestBuilder.getUri());
    }

    @Override
    public void close() {
    }
}

