/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.http;

import de.sfuhrm.radiorecorder.http.ApacheHttpClient4Connection;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApacheHttpClient4ConnectionBuilder
implements HttpConnectionBuilder {
    private static final Logger log = LoggerFactory.getLogger(ApacheHttpClient4ConnectionBuilder.class);
    private final RequestConfig.Builder configBuilder = RequestConfig.custom();
    private final RequestBuilder requestBuilder;

    ApacheHttpClient4ConnectionBuilder(URL url) throws URISyntaxException {
        this.requestBuilder = RequestBuilder.get((URI)url.toURI());
        log.debug("Request for uri {}", (Object)this.requestBuilder.getUri());
    }

    @Override
    public void setConnectTimeout(int timeout) {
        log.debug("Connect timeout is {}", (Object)timeout);
        this.configBuilder.setConnectTimeout(timeout);
        this.configBuilder.setConnectionRequestTimeout(timeout);
    }

    @Override
    public void setReadTimeout(int timeout) {
        log.debug("Read timeout is {}", (Object)timeout);
        this.configBuilder.setSocketTimeout(timeout);
    }

    @Override
    public void setRequestProperty(String key, String value) {
        log.debug("Request property {} => {}", (Object)key, (Object)value);
        this.requestBuilder.addHeader(key, value);
    }

    @Override
    public HttpConnection build() throws IOException {
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(this.configBuilder.build()).build();
        return new ApacheHttpClient4Connection(client, client.execute(this.requestBuilder.build()), this.requestBuilder.getUri());
    }

    @Override
    public void close() {
    }
}

