/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.http.HttpConnectionBuilderFactory;
import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Params {
    private static final Logger log = LoggerFactory.getLogger(Params.class);
    @Option(name="-help", aliases={"-h"}, usage="Show this command line help.", help=true)
    private boolean help;
    @Option(name="-directory", aliases={"-d"}, usage="Write to this directory.", metaVar="DIR")
    private File directory;
    @Option(name="-use-songnames", aliases={"-S"}, usage="Use songnames from retrieved metadata information. Will create one file per detected song.")
    private boolean songNames;
    @Option(name="-limit", aliases={"-l"}, usage="Limit of stations to download in parallel.", metaVar="COUNT")
    private int stationLimit = 10;
    @Option(name="-min-free", aliases={"-M"}, usage="Minimum of free megs on target drive.", metaVar="MEGS")
    private long minimumFreeMegs = 512L;
    @Option(name="-abort-after", usage="Abort after writing the given amount of kilobytes to target drive.", metaVar="KB")
    private Long abortAfterKilo;
    @Option(name="-reconnect", aliases={"-r"}, usage="Automatically reconnect after connection loss.")
    private boolean reconnect;
    @Option(name="-play", aliases={"-p"}, usage="Play live instead of recording to a file.")
    private boolean play;
    @Option(name="-list-cast", aliases={"-L"}, usage="List chromecast devices.")
    private boolean listCast;
    @Option(name="-cast", aliases={"-c"}, usage="Stream to the given chrome cast device.")
    private String castReceiver;
    @Option(name="-timeout", aliases={"-T"}, usage="Connect/read timeout in seconds.", metaVar="SECS")
    private int timeout = 60;
    @Option(name="-client", aliases={"-C"}, usage="Specify HTTP client to use.", metaVar="CLIENT")
    private HttpConnectionBuilderFactory.HttpClientType httpClientType = HttpConnectionBuilderFactory.HttpClientType.APACHE_CLIENT_5;
    @Argument(usage="URLs of the internet radio station(s) or station name for lookup at http://www.radio-browser.info/", metaVar="URLORNAME", required=true)
    private List<String> arguments;

    public static Params parse(String[] args) {
        CmdLineParser cmdLineParser = null;
        try {
            if (log.isDebugEnabled()) {
                log.debug("Args: {}", (Object)Arrays.toString(args));
            }
            Params result = new Params();
            result.directory = new File(System.getProperty("user.home"));
            cmdLineParser = new CmdLineParser((Object)result);
            cmdLineParser.parseArgument(args);
            if (result.help) {
                cmdLineParser.printUsage((OutputStream)System.err);
                return null;
            }
            return result;
        }
        catch (CmdLineException ex) {
            log.warn("Error in parsing", (Throwable)ex);
            System.err.println(ex.getMessage());
            cmdLineParser.printUsage((OutputStream)System.err);
            return null;
        }
    }

    public boolean isHelp() {
        return this.help;
    }

    public File getDirectory() {
        return this.directory;
    }

    public boolean isSongNames() {
        return this.songNames;
    }

    public int getStationLimit() {
        return this.stationLimit;
    }

    public long getMinimumFreeMegs() {
        return this.minimumFreeMegs;
    }

    public Long getAbortAfterKilo() {
        return this.abortAfterKilo;
    }

    public boolean isReconnect() {
        return this.reconnect;
    }

    public boolean isPlay() {
        return this.play;
    }

    public boolean isListCast() {
        return this.listCast;
    }

    public String getCastReceiver() {
        return this.castReceiver;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public HttpConnectionBuilderFactory.HttpClientType getHttpClientType() {
        return this.httpClientType;
    }

    public List<String> getArguments() {
        return this.arguments;
    }
}

