/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiobrowser4j.ListParameter;
import de.sfuhrm.radiobrowser4j.Paging;
import de.sfuhrm.radiobrowser4j.RadioBrowser;
import de.sfuhrm.radiobrowser4j.SearchMode;
import de.sfuhrm.radiobrowser4j.Station;
import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.Params;
import de.sfuhrm.radiorecorder.RadioRunnable;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import su.litvak.chromecast.api.v2.ChromeCast;
import su.litvak.chromecast.api.v2.ChromeCasts;
import su.litvak.chromecast.api.v2.ChromeCastsListener;

public class Main {
    private static final Logger log = LoggerFactory.getLogger(Main.class);
    public static final String GITHUB_URL = "https://github.com/sfuhrm/radiorecorder";
    public static final String PROJECT = "Radio Recorder";
    private static int nextId = 1;

    private static Collection<String> sanitize(List<String> urls, Params params) {
        HashSet<String> result = new HashSet<String>();
        RadioBrowser browser = new RadioBrowser(params.getTimeout() * 1000, GITHUB_URL);
        int limit = params.getStationLimit();
        for (String urlString : urls) {
            try {
                new URL(urlString);
                result.add(urlString);
            }
            catch (MalformedURLException ex) {
                log.debug("URL not valid " + urlString + ", will try to lookup", (Throwable)ex);
                List stations = browser.listStationsBy(Paging.at((int)0, (int)limit), SearchMode.BYNAME, urlString, new ListParameter[0]);
                result.addAll(stations.stream().map(Station::getUrl).collect(Collectors.toList()));
            }
        }
        return result;
    }

    private static ConsumerContext toConsumerContext(Params p, String url) throws MalformedURLException, UnsupportedEncodingException {
        URL myUrl = new URL(url);
        File dir = new File(p.getDirectory(), URLEncoder.encode(myUrl.getHost() + "/" + myUrl.getPath(), "UTF-8"));
        dir.mkdirs();
        return new ConsumerContext(nextId++, myUrl, dir, p);
    }

    private static void listCastDevices() throws InterruptedException, IOException {
        ChromeCasts.registerListener((ChromeCastsListener)new MyListener());
        ChromeCasts.startDiscovery();
        Thread.sleep(5000L);
        ChromeCasts.stopDiscovery();
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        Params params = Params.parse(args);
        if (params == null) {
            return;
        }
        if (params.isListCast()) {
            Main.listCastDevices();
            return;
        }
        if (params.getArguments() == null) {
            System.err.println("Please enter command line arguments (radio urls)");
            return;
        }
        Collection stations = Main.sanitize(params.getArguments(), params);
        if (params.isPlay() && stations.size() > 1) {
            stations = stations.stream().limit(1L).collect(Collectors.toList());
            System.err.println("Restricting to first station because playing.");
        }
        stations.stream().forEach(url -> {
            try {
                System.err.println((String)url);
                RadioRunnable r = new RadioRunnable(Main.toConsumerContext(params, url));
                Thread t = new Thread((Runnable)r, (String)url);
                t.start();
            }
            catch (IOException ex) {
                log.warn("Could not start thread for url " + url, (Throwable)ex);
            }
        });
    }

    private static class MyListener
    implements ChromeCastsListener {
        private MyListener() {
        }

        public void newChromeCastDiscovered(ChromeCast chromeCast) {
            System.out.printf("%s - %s%n", chromeCast.getTitle(), chromeCast.getModel());
        }

        public void chromeCastRemoved(ChromeCast chromeCast) {
        }
    }
}

