/*
 * Decompiled with CFR 0.152.
 */
package javax.jmdns.impl.constants;

public enum DNSState {
    PROBING_1("probing 1", StateClass.probing),
    PROBING_2("probing 2", StateClass.probing),
    PROBING_3("probing 3", StateClass.probing),
    ANNOUNCING_1("announcing 1", StateClass.announcing),
    ANNOUNCING_2("announcing 2", StateClass.announcing),
    ANNOUNCED("announced", StateClass.announced),
    CANCELING_1("canceling 1", StateClass.canceling),
    CANCELING_2("canceling 2", StateClass.canceling),
    CANCELING_3("canceling 3", StateClass.canceling),
    CANCELED("canceled", StateClass.canceled),
    CLOSING("closing", StateClass.closing),
    CLOSED("closed", StateClass.closed);

    private final String name;
    private final StateClass state;

    private DNSState(String name, StateClass state) {
        this.name = name;
        this.state = state;
    }

    public final String toString() {
        return this.name;
    }

    public final DNSState advance() {
        switch (this.ordinal()) {
            case 0: {
                return PROBING_2;
            }
            case 1: {
                return PROBING_3;
            }
            case 2: {
                return ANNOUNCING_1;
            }
            case 3: {
                return ANNOUNCING_2;
            }
            case 4: 
            case 5: {
                return ANNOUNCED;
            }
            case 6: {
                return CANCELING_2;
            }
            case 7: {
                return CANCELING_3;
            }
            case 8: 
            case 9: {
                return CANCELED;
            }
            case 10: 
            case 11: {
                return CLOSED;
            }
        }
        return this;
    }

    public final DNSState revert() {
        switch (this.ordinal()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return PROBING_1;
            }
            case 6: 
            case 7: 
            case 8: {
                return CANCELING_1;
            }
            case 9: {
                return CANCELED;
            }
            case 10: {
                return CLOSING;
            }
            case 11: {
                return CLOSED;
            }
        }
        return this;
    }

    public final boolean isProbing() {
        return this.state == StateClass.probing;
    }

    public final boolean isAnnouncing() {
        return this.state == StateClass.announcing;
    }

    public final boolean isAnnounced() {
        return this.state == StateClass.announced;
    }

    public final boolean isCanceling() {
        return this.state == StateClass.canceling;
    }

    public final boolean isCanceled() {
        return this.state == StateClass.canceled;
    }

    public final boolean isClosing() {
        return this.state == StateClass.closing;
    }

    public final boolean isClosed() {
        return this.state == StateClass.closed;
    }

    private static enum StateClass {
        probing,
        announcing,
        announced,
        canceling,
        canceled,
        closing,
        closed;

    }
}

