/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.metadata;

import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.IcyMetaFilterStream;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.OffsetFilterStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamMetaData {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamMetaData.class);
    private OffsetFilterStream offsetFilterStream;
    private IcyMetaFilterStream icyMetaFilterStream;
    private static final String ICY_METAINT = "icy-metaint";
    private static final String ICY_NAME = "icy-name";
    private static final String ICY_URL = "icy-url";
    private Consumer<MetaData> metaDataConsumer = l -> {};
    private MetaData metaData = new MetaData();
    private boolean providesMetaData;
    private static final Pattern artistTitlePattern = Pattern.compile("(.{2,}) - (.{2,})");

    public InputStream openStream(@NonNull HttpConnection connection) throws IOException {
        if (connection == null) {
            throw new NullPointerException("connection is marked non-null but is null");
        }
        OffsetFilterStream result = this.offsetFilterStream = new OffsetFilterStream(connection.getInputStream());
        Map<String, List<String>> headersOriginal = connection.getHeaderFields();
        Map<String, List> headers = headersOriginal.entrySet().stream().collect(Collectors.toMap(e -> ((String)e.getKey()).toLowerCase(), Map.Entry::getValue));
        if (headers.containsKey(ICY_NAME)) {
            String stationName = (String)headers.get(ICY_NAME).get(0);
            log.debug("Station name: {}", (Object)stationName);
            this.metaData.setStationName(Optional.of(stationName));
        }
        if (headers.containsKey(ICY_URL)) {
            String stationUrl = (String)headers.get(ICY_URL).get(0);
            log.debug("Station url: {}", (Object)stationUrl);
            this.metaData.setStationUrl(Optional.of(stationUrl));
        }
        if (headers.containsKey(ICY_METAINT)) {
            this.providesMetaData = true;
            log.debug("Found Icy Meta Interval header: {}", (Object)headers.containsKey(ICY_METAINT));
            int metaInterval = Integer.parseInt((String)headers.get(ICY_METAINT).get(0));
            this.icyMetaFilterStream = new IcyMetaFilterStream(metaInterval, this.offsetFilterStream);
            this.icyMetaFilterStream.setMetaDataConsumer((String md) -> {
                MetaData target;
                this.metaData = target = StreamMetaData.parse(this.metaData, this.offsetFilterStream.getOffset(), md);
                this.metaDataConsumer.accept(target);
            });
            result = this.icyMetaFilterStream;
        } else {
            this.providesMetaData = false;
        }
        return result;
    }

    static MetaData parse(MetaData oldMetaData, long offset, String streamMetaData) {
        Matcher m = artistTitlePattern.matcher(streamMetaData);
        MetaData target = oldMetaData.clone();
        target.setCreated(ZonedDateTime.now());
        target.setIndex(Optional.of(1 + oldMetaData.getIndex().orElse(-1)));
        target.setOffset(Optional.of(offset));
        if (m.matches()) {
            String artist = m.group(1);
            String title = m.group(2);
            log.debug("Icy Meta artist: {}, icy meta title: {}", (Object)artist, (Object)title);
            target.setArtist(Optional.of(artist));
            target.setTitle(Optional.of(title));
        } else {
            log.info("Icy Meta data was malformed: {}", (Object)streamMetaData);
            target.setArtist(Optional.empty());
            target.setTitle(Optional.of(streamMetaData));
        }
        return target;
    }

    @Generated
    public Consumer<MetaData> getMetaDataConsumer() {
        return this.metaDataConsumer;
    }

    @Generated
    public void setMetaDataConsumer(Consumer<MetaData> metaDataConsumer) {
        this.metaDataConsumer = metaDataConsumer;
    }

    @Generated
    public boolean isProvidesMetaData() {
        return this.providesMetaData;
    }
}

