/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.AbstractConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import javax.xml.xpath.XPathFactoryConfigurationException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XSPFConsumer
extends AbstractConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(XSPFConsumer.class);
    private static final String NS = "http://xspf.org/ns/0/";
    private static final String PREFIX = "x";

    public XSPFConsumer(ConsumerContext context) {
        super(context);
    }

    @Override
    protected void _accept(HttpConnection t) {
        try (InputStream is = t.getInputStream();){
            XPathFactory factory = XPathFactory.newInstance();
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            XPath xp = factory.newXPath();
            xp.setNamespaceContext(new NamespaceContext(this){

                @Override
                public String getNamespaceURI(String prefix) {
                    return prefix.equals(XSPFConsumer.PREFIX) ? XSPFConsumer.NS : "";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return XSPFConsumer.NS.equals(namespaceURI) ? XSPFConsumer.PREFIX : null;
                }

                @Override
                public Iterator<String> getPrefixes(String namespaceURI) {
                    return namespaceURI.equals(XSPFConsumer.NS) ? Collections.singletonList(XSPFConsumer.PREFIX).iterator() : Collections.emptyIterator();
                }
            });
            InputSource inputSource = new InputSource(is);
            NodeList nl = (NodeList)xp.evaluate("/x:playlist/x:trackList/x:track/x:location", inputSource, XPathConstants.NODESET);
            for (int i = 0; i < nl.getLength(); ++i) {
                Node n = nl.item(i);
                String url = n.getTextContent();
                this.getConnectionHandler().consume(URI.create(url));
            }
        }
        catch (XPathExpressionException | XPathFactoryConfigurationException ex) {
            throw new RadioException(false, (Throwable)ex);
        }
        catch (IOException ex) {
            log.warn("URL {} broke down", (Object)this.getContext().getUri().toASCIIString(), (Object)ex);
            throw new RadioException(true, (Throwable)ex);
        }
    }
}

