/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import com.mpatric.mp3agic.ID3v1;
import com.mpatric.mp3agic.ID3v1Tag;
import com.mpatric.mp3agic.ID3v2;
import com.mpatric.mp3agic.ID3v24Tag;
import com.mpatric.mp3agic.InvalidDataException;
import com.mpatric.mp3agic.Mp3File;
import com.mpatric.mp3agic.NotSupportedException;
import com.mpatric.mp3agic.UnsupportedTagException;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ID3Tagger
implements Runnable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ID3Tagger.class);
    private final MetaData metaData;
    private final Path file;

    ID3Tagger(@NonNull MetaData md, @NonNull Path file) {
        if (md == null) {
            throw new NullPointerException("md is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.metaData = md;
        this.file = file;
    }

    @Override
    public void run() {
        try {
            log.debug("Adding id3 tag to {}", (Object)this.file);
            Mp3File mp3File = new Mp3File(this.file);
            ID3v1Tag id3v1 = new ID3v1Tag();
            this.metaData.getTitle().ifPresent(arg_0 -> ((ID3v1)id3v1).setTitle(arg_0));
            this.metaData.getArtist().ifPresent(arg_0 -> ((ID3v1)id3v1).setArtist(arg_0));
            this.metaData.getStationName().ifPresent(arg_0 -> ((ID3v1)id3v1).setComment(arg_0));
            this.metaData.getIndex().ifPresent(arg_0 -> ID3Tagger.lambda$run$0((ID3v1)id3v1, arg_0));
            mp3File.setId3v1Tag((ID3v1)id3v1);
            ID3v24Tag id3v2 = new ID3v24Tag();
            this.metaData.getTitle().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setTitle(arg_0));
            this.metaData.getArtist().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setArtist(arg_0));
            this.metaData.getStationName().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setPublisher(arg_0));
            this.metaData.getStationUrl().ifPresent(arg_0 -> ((ID3v24Tag)id3v2).setRadiostationUrl(arg_0));
            this.metaData.getIndex().ifPresent(value -> id3v2.setTrack(value.toString()));
            id3v2.setComment("Radio Recorder");
            id3v2.setUrl("https://github.com/sfuhrm/radiorecorder");
            mp3File.setId3v2Tag((ID3v2)id3v2);
            Path bak = this.file.getParent().resolve(String.valueOf(this.file.getFileName()) + ".bak");
            Path tmp = this.file.getParent().resolve(String.valueOf(this.file.getFileName()) + ".tmp");
            mp3File.save(tmp.toFile().getAbsolutePath());
            Files.move(this.file, bak, new CopyOption[0]);
            Files.move(tmp, this.file, new CopyOption[0]);
            Files.delete(bak);
            log.debug("Done adding id3 tag to {}", (Object)this.file);
        }
        catch (InvalidDataException | NotSupportedException | UnsupportedTagException | IOException ex) {
            log.warn("Exception while writing id3 tag for {}", (Object)this.file, (Object)ex);
        }
    }

    private static /* synthetic */ void lambda$run$0(ID3v1 id3v1, Integer value) {
        id3v1.setTrack(value.toString());
    }
}

