/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConnectionHandler;
import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.IOException;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractConsumer.class);
    private final ConsumerContext context;
    private ConnectionHandler connectionHandler;

    public AbstractConsumer(@NonNull ConsumerContext context) {
        if (context == null) {
            throw new NullPointerException("context is marked non-null but is null");
        }
        this.context = context;
        this.connectionHandler = new ConnectionHandler(context);
    }

    @Override
    public final void accept(HttpConnection u) {
        try {
            log.debug("Source URL is {}, real URL is {}", (Object)this.getContext().getUri(), (Object)u.getURI().toASCIIString());
            log.debug("HTTP {} {}", (Object)u.getResponseCode(), (Object)u.getResponseMessage());
            if (log.isDebugEnabled()) {
                log.debug("HTTP Response Header fields");
                u.getHeaderFields().entrySet().stream().forEach(e -> log.debug("  {}: {}", e.getKey(), e.getValue()));
            }
        }
        catch (IOException ex) {
            log.warn("Error in HTTP communication", (Throwable)ex);
            throw new RadioException(true, (Throwable)ex);
        }
        this._accept(u);
    }

    protected abstract void _accept(HttpConnection var1);

    @Generated
    public ConsumerContext getContext() {
        return this.context;
    }

    @Generated
    public ConnectionHandler getConnectionHandler() {
        return this.connectionHandler;
    }

    @Generated
    void setConnectionHandler(ConnectionHandler connectionHandler) {
        this.connectionHandler = connectionHandler;
    }
}

