/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.aachelper;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AACClassLoaderHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AACClassLoaderHelper.class);
    private static final String REMOTE_URL_AAC = "https://repo1.maven.org/maven2/com/tianscar/javasound/javasound-aac/0.9.8/javasound-aac-0.9.8.jar";
    private static final String REMOTE_URL_RES = "https://repo1.maven.org/maven2/com/tianscar/javasound/javasound-resloader/0.1.3/javasound-resloader-0.1.3.jar";
    private static final String LOCAL_JAR_AAC = "/lib/javasound-aac-0.9.8.jar";
    private static final String LOCAL_JAR_RES = "/lib/javasound-resloader-0.1.3.jar";

    static Optional<Path> findLibsDirectory() {
        try {
            URI uri = AACClassLoaderHelper.class.getProtectionDomain().getCodeSource().getLocation().toURI();
            Path path = Paths.get(uri);
            if (Files.isRegularFile(path, new LinkOption[0])) {
                log.debug("Path {} is regular file, we are in a jar", (Object)path);
                return Optional.of(path.getParent());
            }
        }
        catch (URISyntaxException e) {
            log.debug("Exception, but it is ok {}", (Object)e.getMessage());
            return Optional.empty();
        }
        return Optional.empty();
    }

    static ClassLoader loadPluginClassLoaderRemoteUrl() throws MalformedURLException {
        List<URL> urls = Arrays.asList(URI.create(REMOTE_URL_AAC).toURL(), URI.create(REMOTE_URL_RES).toURL());
        URL[] urlArray = urls.toArray(new URL[0]);
        return new URLClassLoader(urlArray, AACClassLoaderHelper.class.getClassLoader());
    }

    static Optional<ClassLoader> loadPluginClassLoaderJarResources() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String jar : Arrays.asList(LOCAL_JAR_AAC, LOCAL_JAR_RES)) {
            URL url = AACClassLoaderHelper.class.getResource(jar);
            if (url == null) {
                log.debug("Could not find jar {} in classpath", (Object)jar);
                return Optional.empty();
            }
            URL tempFileUrl = null;
            try {
                tempFileUrl = AACClassLoaderHelper.copyToTempFile(url);
            }
            catch (IOException e) {
                log.debug("Could not copy " + url.toExternalForm() + " to temp file", (Throwable)e);
                return Optional.empty();
            }
            urls.add(tempFileUrl);
        }
        log.debug("Found JARs: {}", urls);
        URL[] urlArray = urls.toArray(new URL[0]);
        return Optional.of(new URLClassLoader(urlArray, AACClassLoaderHelper.class.getClassLoader()));
    }

    private static URL copyToTempFile(URL jarUrl) throws IOException {
        Path tempFile = Files.createTempFile("radiorecorder", ".jar", new FileAttribute[0]);
        try (OutputStream outputStream = Files.newOutputStream(tempFile, StandardOpenOption.CREATE);){
            URL uRL;
            block12: {
                InputStream inputStream = jarUrl.openStream();
                try {
                    inputStream.transferTo(outputStream);
                    uRL = tempFile.toUri().toURL();
                    if (inputStream == null) break block12;
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                inputStream.close();
            }
            return uRL;
        }
    }

    public static ClassLoader loadPluginClassLoader() throws MalformedURLException {
        ClassLoader result;
        Optional<ClassLoader> jarResourceClassLoader = AACClassLoaderHelper.loadPluginClassLoaderJarResources();
        if (jarResourceClassLoader.isPresent()) {
            result = jarResourceClassLoader.get();
        } else {
            log.warn("Using remote JARs, should only be used for development!");
            result = AACClassLoaderHelper.loadPluginClassLoaderRemoteUrl();
        }
        return result;
    }
}

