/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiobrowser4j.Station;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Radio {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Radio.class);
    private String name;
    private URI uri;
    private UUID uuid;
    private URI favIconUrl;
    private String codec;
    private int bitrate;
    private List<String> tags = Collections.emptyList();

    static Radio fromStation(Station s) {
        Radio r = new Radio();
        String stationName = s.getName();
        if (stationName != null) {
            stationName = stationName.trim();
            r.setName(stationName);
        } else {
            r.setName(s.getStationUUID().toString());
        }
        if (s.getUrl() != null) {
            URI uri = URI.create(s.getUrl());
            r.setUri(uri);
        }
        r.setUuid(s.getStationUUID());
        if (s.getFavicon() != null && !s.getFavicon().isEmpty()) {
            r.setFavIconUrl(URI.create(s.getFavicon()));
        }
        r.setCodec(s.getCodec());
        if (s.getBitrate() != null) {
            r.setBitrate(s.getBitrate());
        }
        r.setTags(new ArrayList<String>(s.getTagList()));
        return r;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public URI getUri() {
        return this.uri;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public URI getFavIconUrl() {
        return this.favIconUrl;
    }

    @Generated
    public String getCodec() {
        return this.codec;
    }

    @Generated
    public int getBitrate() {
        return this.bitrate;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setFavIconUrl(URI favIconUrl) {
        this.favIconUrl = favIconUrl;
    }

    @Generated
    public void setCodec(String codec) {
        this.codec = codec;
    }

    @Generated
    public void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    @Generated
    public void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    public String toString() {
        return "Radio(name=" + this.getName() + ", uri=" + String.valueOf(this.getUri()) + ", uuid=" + String.valueOf(this.getUuid()) + ", favIconUrl=" + String.valueOf(this.getFavIconUrl()) + ", codec=" + this.getCodec() + ", bitrate=" + this.getBitrate() + ", tags=" + String.valueOf(this.getTags()) + ")";
    }
}

