/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.M3UConsumer;
import de.sfuhrm.radiorecorder.consumer.PLSConsumer;
import de.sfuhrm.radiorecorder.consumer.StreamCastConsumer;
import de.sfuhrm.radiorecorder.consumer.StreamCopyConsumer;
import de.sfuhrm.radiorecorder.consumer.StreamPlayConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilder;
import de.sfuhrm.radiorecorder.http.HttpConnectionBuilderFactory;
import de.sfuhrm.radiorecorder.metadata.MimeType;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionHandler.class);
    private final ConsumerContext consumerContext;
    private final HttpConnectionBuilderFactory builderFactory;
    private static final long GRACE_PERIOD = 5000L;

    public ConnectionHandler(@NonNull ConsumerContext consumerContext) {
        this.consumerContext = Objects.requireNonNull(consumerContext);
        this.builderFactory = new HttpConnectionBuilderFactory(consumerContext.getHttpClient());
    }

    protected void configureTimeout(HttpConnectionBuilder builder) {
        builder.setConnectTimeout(this.consumerContext.getTimeout());
        builder.setReadTimeout(this.consumerContext.getTimeout());
    }

    protected void configureProxy(HttpConnectionBuilder builder) {
        if (this.consumerContext.getProxy() != null) {
            builder.setProxy(this.consumerContext.getProxy());
        }
    }

    protected void configureIcecast(HttpConnectionBuilder builder) {
        builder.setRequestProperty("Icy-Metadata", "1");
    }

    protected void configureClient(HttpConnectionBuilder builder) {
        builder.setRequestProperty("User-Agent", "Radio Recorder");
    }

    protected void configure(@NonNull HttpConnectionBuilder builder) {
        if (builder == null) {
            throw new NullPointerException("builder is marked non-null but is null");
        }
        this.configureIcecast(builder);
        this.configureTimeout(builder);
        this.configureClient(builder);
        this.configureProxy(builder);
    }

    private HttpConnection openConnection(URI uri) throws RadioException {
        try {
            HttpConnectionBuilder builder = this.builderFactory.newInstance(uri);
            this.configure(builder);
            return builder.build();
        }
        catch (IOException ex) {
            throw new RadioException(true, (Throwable)ex);
        }
    }

    public void consume(@NonNull URI uri) {
        if (uri == null) {
            throw new NullPointerException("uri is marked non-null but is null");
        }
        boolean first = true;
        boolean loop = this.consumerContext.isReconnect();
        do {
            if (!first) {
                log.info("Sleeping for {} millis before retry", (Object)5000L);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException ex) {
                    log.debug("Interrupted", (Throwable)ex);
                }
                log.info("Reconnecting.");
            }
            try {
                first = false;
                HttpConnection connection = this.openConnection(uri);
                Consumer<HttpConnection> consumer = ConnectionHandler.consumerFromContentType(this.consumerContext, connection.getContentType());
                consumer.accept(connection);
                loop = false;
            }
            catch (RadioException re) {
                log.debug("Retrying after {}? retryable={}, will retry={}", new Object[]{re.getMessage(), re.isRetryable(), loop &= re.isRetryable()});
            }
        } while (loop);
    }

    private static Consumer<HttpConnection> consumerFromContentType(ConsumerContext cc, String contentType) {
        Optional<MimeType> mimeType = MimeType.byContentType(contentType);
        if (!mimeType.isPresent()) {
            log.warn("Unknown content type {}", (Object)contentType);
            return t -> {};
        }
        switch (mimeType.get()) {
            case AUDIO_MPEG: 
            case AUDIO_OGG: 
            case APPLICATION_OGG: 
            case AUDIO_XWAV: 
            case AUDIO_XMSWMA: 
            case AUDIO_AAC: {
                if (cc.getCastReceiver() != null) {
                    return new StreamCastConsumer(cc);
                }
                if (cc.isPlaying()) {
                    return new StreamPlayConsumer(cc);
                }
                return new StreamCopyConsumer(cc);
            }
            case AUDIO_MPEGURL: 
            case AUDIO_XMPEGURL: {
                return new M3UConsumer(cc);
            }
            case APPLICATION_PLS_XML: 
            case AUDIO_XSCPLS: {
                return new PLSConsumer(cc);
            }
        }
        log.warn("Unknown content type {}", (Object)contentType);
        return t -> {};
    }
}

