/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.AbstractConsumer;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PLSConsumer
extends AbstractConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PLSConsumer.class);

    public PLSConsumer(ConsumerContext context) {
        super(context);
    }

    static List<String> readUrls(InputStream i) throws UnsupportedEncodingException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(i, StandardCharsets.US_ASCII));
        return bufferedReader.lines().filter(l -> l.startsWith("File")).filter(l -> l.contains("=")).map(l -> l.substring(l.indexOf(61) + 1)).filter(l -> l.startsWith("http")).collect(Collectors.toList());
    }

    @Override
    protected void _accept(HttpConnection t) {
        try (InputStream is = t.getInputStream();){
            List<String> urls = PLSConsumer.readUrls(is);
            for (String url : urls) {
                this.getConnectionHandler().consume(URI.create(url));
            }
        }
        catch (IOException ex) {
            log.warn("URL {} broke down", (Object)this.getContext().getUri().toASCIIString(), (Object)ex);
            throw new RadioException(true, (Throwable)ex);
        }
    }
}

