/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import lombok.Generated;

class ListHelper<T> {
    private final List<T> list;
    private final List<ColumnInfo> columns;

    ListHelper(List<T> inList) {
        this.list = new ArrayList<T>(inList);
        this.columns = new ArrayList<ColumnInfo>();
    }

    void addColumn(String name, Function<T, String> formatter) {
        this.columns.add(new ColumnInfo(this, this.columns.size(), name, formatter, name.length()));
    }

    private void calculateSizes() {
        for (T item : this.list) {
            for (ColumnInfo columnInfo : this.columns) {
                columnInfo.maxLength = Math.max(columnInfo.maxLength, columnInfo.formatter.apply(item).length());
            }
        }
    }

    String fill(String in, int length) {
        StringBuilder sb = new StringBuilder(in);
        while (sb.length() < length) {
            sb.append(' ');
        }
        return sb.toString();
    }

    void print(PrintStream ps) {
        this.calculateSizes();
        for (ColumnInfo columnInfo : this.columns) {
            ps.print(this.fill(columnInfo.name, columnInfo.maxLength));
            ps.print(' ');
        }
        ps.print("\n");
        for (ColumnInfo item : this.list) {
            for (ColumnInfo columnInfo : this.columns) {
                ps.print(this.fill(columnInfo.formatter.apply(item), columnInfo.maxLength));
                ps.print(' ');
            }
            ps.print("\n");
        }
    }

    private class ColumnInfo {
        int index;
        private String name;
        private Function<T, String> formatter;
        int maxLength;

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Function<T, String> getFormatter() {
            return this.formatter;
        }

        @Generated
        public int getMaxLength() {
            return this.maxLength;
        }

        @Generated
        public void setIndex(int index) {
            this.index = index;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setFormatter(Function<T, String> formatter) {
            this.formatter = formatter;
        }

        @Generated
        public void setMaxLength(int maxLength) {
            this.maxLength = maxLength;
        }

        @Generated
        public ColumnInfo(ListHelper listHelper, int index, String name, Function<T, String> formatter, int maxLength) {
            this.index = index;
            this.name = name;
            this.formatter = formatter;
            this.maxLength = maxLength;
        }
    }
}

