/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiobrowser4j;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import de.sfuhrm.radiobrowser4j.RadioBrowserException;
import de.sfuhrm.radiobrowser4j.Station;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import java.util.function.BiConsumer;

class StationDeserializer
implements JsonDeserializer<Station> {
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");

    StationDeserializer() {
    }

    public Station deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Station station = new Station();
        JsonObject jsonObject = jsonElement.getAsJsonObject();
        station.setLastcheckok(jsonObject.get("lastcheckok").getAsInt());
        try {
            this.transfer(jsonObject, "stationuuid", station, Station::setStationUUID, UUID.class);
            this.transfer(jsonObject, "changeuuid", station, Station::setChangeUUID, UUID.class);
            this.transfer(jsonObject, "url", station, Station::setUrl, String.class);
            this.transfer(jsonObject, "url_resolved", station, Station::setUrlResolved, String.class);
            this.transfer(jsonObject, "homepage", station, Station::setHomepage, String.class);
            this.transfer(jsonObject, "favicon", station, Station::setFavicon, String.class);
            this.transfer(jsonObject, "tags", station, Station::setTags, String.class);
            this.transfer(jsonObject, "countrycode", station, Station::setCountryCode, String.class);
            this.transfer(jsonObject, "state", station, Station::setState, String.class);
            this.transfer(jsonObject, "language", station, Station::setLanguage, String.class);
            this.transfer(jsonObject, "votes", station, Station::setVotes, Integer.class);
            this.transfer(jsonObject, "codec", station, Station::setCodec, String.class);
            this.transfer(jsonObject, "bitrate", station, Station::setBitrate, Integer.class);
            this.transfer(jsonObject, "hls", station, Station::setHls, String.class);
            this.transfer(jsonObject, "lastchecktime", station, Station::setLastchecktime, Date.class);
            this.transfer(jsonObject, "lastcheckoktime", station, Station::setLastcheckoktime, Date.class);
            this.transfer(jsonObject, "lastchangetime", station, Station::setLastchangetime, Date.class);
            this.transfer(jsonObject, "lastlocalchecktime", station, Station::setLastlocalchecktime, Date.class);
            this.transfer(jsonObject, "clicktimestamp", station, Station::setClicktimestamp, Date.class);
            this.transfer(jsonObject, "clickcount", station, Station::setClickcount, Integer.class);
            this.transfer(jsonObject, "clicktrend", station, Station::setClicktrend, Integer.class);
            this.transfer(jsonObject, "name", station, Station::setName, String.class);
            this.transfer(jsonObject, "geo_lat", station, Station::setGeoLatitude, Double.class);
            this.transfer(jsonObject, "geo_long", station, Station::setGeoLongitude, Double.class);
            this.transfer(jsonObject, "has_extended_info", station, Station::setHasExtendedInfo, Boolean.class);
        }
        catch (ParseException e) {
            throw new RadioBrowserException(e);
        }
        return station;
    }

    <T> void transfer(JsonObject jsonObject, String key, Station station, BiConsumer<Station, T> setter, Class<T> type) throws ParseException {
        JsonElement element = jsonObject.get(key);
        if (element == null || element.isJsonNull()) {
            return;
        }
        if (type == String.class) {
            setter.accept(station, (Station)((Object)element.getAsString()));
            return;
        }
        if (type == Date.class) {
            if (element.getAsString().isEmpty()) {
                return;
            }
            setter.accept(station, (Station)((Object)this.dateFormat.parse(element.getAsString())));
            return;
        }
        if (type == UUID.class) {
            if (element.getAsString().isEmpty()) {
                return;
            }
            setter.accept(station, (Station)((Object)UUID.fromString(element.getAsString())));
            return;
        }
        if (type == Integer.class) {
            setter.accept(station, (Station)((Object)Integer.valueOf(element.getAsInt())));
            return;
        }
        if (type == Double.class) {
            setter.accept(station, (Station)((Object)Double.valueOf(element.getAsDouble())));
            return;
        }
        if (type == Boolean.class) {
            setter.accept(station, (Station)((Object)Boolean.valueOf(element.getAsBoolean())));
            return;
        }
        throw new IllegalArgumentException("Unsupported type: " + type + " for field " + key);
    }
}

