/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.IOException;
import net.sourceforge.jaad.SampleBuffer;
import net.sourceforge.jaad.aac.Decoder;
import net.sourceforge.jaad.mp4.api.AudioTrack;
import net.sourceforge.jaad.mp4.api.Frame;
import net.sourceforge.jaad.spi.javasound.AsynchronousAudioInputStream;
import net.sourceforge.jaad.spi.javasound.MP4AudioInputStream;
import net.sourceforge.jaad.spi.javasound.Utils;

class DecodedMP4AudioInputStream
extends AsynchronousAudioInputStream {
    final AudioTrack track;
    final Decoder decoder;
    final SampleBuffer sampleBuffer;

    DecodedMP4AudioInputStream(MP4AudioInputStream stream) throws IOException {
        super(stream.in, Utils.getPCMFormat(stream.getFormat()), stream.getFrameLength());
        this.track = stream.track;
        this.decoder = stream.decoder;
        this.sampleBuffer = stream.sampleBuffer;
    }

    @Override
    public void execute() {
        this.decodeFrame();
        if (this.buffer.isOpen()) {
            this.buffer.write(this.sampleBuffer.getData());
        }
    }

    private void decodeFrame() {
        if (!this.track.hasMoreFrames()) {
            this.buffer.close();
            return;
        }
        try {
            Frame frame = this.track.readNextFrame();
            if (frame == null) {
                this.buffer.close();
                return;
            }
            this.decoder.decodeFrame(frame.getData(), this.sampleBuffer);
        }
        catch (IOException e) {
            this.buffer.close();
        }
    }
}

