/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jaad.spi.javasound;

import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.spi.FormatConversionProvider;
import net.sourceforge.jaad.spi.javasound.AACAudioFormat;
import net.sourceforge.jaad.spi.javasound.AACAudioInputStream;
import net.sourceforge.jaad.spi.javasound.DecodedAACAudioInputStream;
import net.sourceforge.jaad.spi.javasound.DecodedMP4AudioInputStream;
import net.sourceforge.jaad.spi.javasound.MP4AudioInputStream;

public class AACFormatConversionProvider
extends FormatConversionProvider {
    private static final AudioFormat.Encoding[] SOURCE_ENCODINGS = new AudioFormat.Encoding[]{AACAudioFormat.Encoding.AAC};
    private static final AudioFormat.Encoding[] TARGET_ENCODINGS = new AudioFormat.Encoding[]{AudioFormat.Encoding.PCM_SIGNED};

    @Override
    public AudioFormat.Encoding[] getSourceEncodings() {
        return (AudioFormat.Encoding[])SOURCE_ENCODINGS.clone();
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings() {
        return (AudioFormat.Encoding[])TARGET_ENCODINGS.clone();
    }

    @Override
    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AACAudioFormat.Encoding.AAC)) {
            return (AudioFormat.Encoding[])TARGET_ENCODINGS.clone();
        }
        return new AudioFormat.Encoding[0];
    }

    @Override
    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (sourceFormat.getEncoding().equals(AACAudioFormat.Encoding.AAC)) {
            return new AudioFormat[]{AACFormatConversionProvider.getTargetFormat(sourceFormat)};
        }
        return new AudioFormat[0];
    }

    private static AudioFormat getTargetFormat(AudioFormat sourceFormat) {
        return new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, -1.0f, sourceFormat.getSampleSizeInBits(), sourceFormat.getChannels(), -1, -1.0f, sourceFormat.isBigEndian());
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat.Encoding targetEncoding, AudioInputStream sourceStream) {
        return this.getAudioInputStream(AACFormatConversionProvider.getTargetFormat(sourceStream.getFormat()), sourceStream);
    }

    @Override
    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream sourceStream) {
        if (targetFormat.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED) && sourceStream.getFormat().getEncoding().equals(AACAudioFormat.Encoding.AAC)) {
            AudioFormat sourceFormat = sourceStream.getFormat();
            if (sourceFormat.isBigEndian() == targetFormat.isBigEndian() && sourceFormat.getChannels() == targetFormat.getChannels() && sourceFormat.getSampleSizeInBits() == targetFormat.getSampleSizeInBits()) {
                try {
                    if (sourceStream instanceof AACAudioInputStream) {
                        return new DecodedAACAudioInputStream((AACAudioInputStream)sourceStream);
                    }
                    if (sourceStream instanceof MP4AudioInputStream) {
                        return new DecodedMP4AudioInputStream((MP4AudioInputStream)sourceStream);
                    }
                    throw new IllegalArgumentException("conversion not supported");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("unable to convert " + sourceFormat + " to " + targetFormat);
        }
        throw new IllegalArgumentException("conversion not supported");
    }
}

