/*
 * Decompiled with CFR 0.152.
 */
package de.sfuhrm.radiorecorder.consumer;

import de.sfuhrm.radiorecorder.ConsumerContext;
import de.sfuhrm.radiorecorder.RadioException;
import de.sfuhrm.radiorecorder.consumer.ConsoleMetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.ID3Tagger;
import de.sfuhrm.radiorecorder.consumer.MetaDataConsumer;
import de.sfuhrm.radiorecorder.consumer.MetaDataFileNameGenerator;
import de.sfuhrm.radiorecorder.http.HttpConnection;
import de.sfuhrm.radiorecorder.metadata.MetaData;
import de.sfuhrm.radiorecorder.metadata.MimeType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamCopyConsumer
extends MetaDataConsumer
implements Consumer<HttpConnection> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StreamCopyConsumer.class);
    private final long creationTimeStamp = System.currentTimeMillis();
    private int fileNumber;
    private MetaData metaData;
    private MetaData previousMetaData;
    private boolean metaDataChanged;
    private final Path targetDirectory;
    private Path fileNullable = null;
    private OutputStream outputStreamNullable = null;
    private final Supplier<MetaDataFileNameGenerator> fileNameGeneratorSupplier = () -> this.useSongNames() ? new MetaDataFileNameGenerator(consumerContext.getSongnameFormat(), consumerContext, true) : new MetaDataFileNameGenerator(consumerContext.getNoSongnameFormat(), consumerContext, false);

    public StreamCopyConsumer(ConsumerContext consumerContext) {
        super(consumerContext);
        this.targetDirectory = consumerContext.getTargetDirectory();
    }

    private boolean useSongNames() {
        return this.getStreamMetaData().isProvidesMetaData() && this.getContext().isSongNames();
    }

    private boolean needToAbort(Path currentFileOrNull) throws IOException {
        long required;
        FileStore fileStore;
        long free;
        if (currentFileOrNull != null) {
            long length = Files.size(currentFileOrNull);
            if (this.getContext().getAbortAfterFileLength().isPresent() && length > this.getContext().getAbortAfterFileLength().get()) {
                log.warn("Aborting due to maximum file size of {} exceeded: {} file size, {} is the abort-after size", new Object[]{currentFileOrNull, length, this.getContext().getAbortAfterFileLength().get()});
                return true;
            }
        }
        if ((free = (fileStore = Files.getFileStore(this.targetDirectory)).getUsableSpace()) < (required = this.getContext().getMinFree())) {
            log.warn("Path {} is too full, has less than {} bytes free", (Object)this.targetDirectory, (Object)required);
            return true;
        }
        if (this.getContext().getAbortAfterDuration().isPresent()) {
            long abortAfterMillis = this.getContext().getAbortAfterDuration().get();
            long elapsedMillis = System.currentTimeMillis() - this.creationTimeStamp;
            if (elapsedMillis > abortAfterMillis) {
                log.warn("Aborting due to maximum duration of {}ms", (Object)(System.currentTimeMillis() - this.creationTimeStamp));
                return true;
            }
        }
        return false;
    }

    private void closeOldFileAndReopenWithNewMetadata(MimeType contentTypeOrNull) throws IOException {
        log.debug("Meta data changed");
        this.metaDataChanged = false;
        this.closeStreamIfOpen(this.outputStreamNullable, this.fileNullable, contentTypeOrNull);
        Optional<Path> optionalPath = this.fileNameGeneratorSupplier.get().getFileFrom(this.getContext().getRadio(), this.metaData, contentTypeOrNull);
        if (optionalPath.isPresent()) {
            this.fileNullable = optionalPath.get();
            this.ensureParentDirectoriesExist(this.fileNullable);
            this.outputStreamNullable = Files.newOutputStream(this.fileNullable, StandardOpenOption.CREATE_NEW);
        } else {
            this.fileNullable = null;
            this.outputStreamNullable = null;
        }
        log.debug("New file {}", (Object)this.fileNullable);
    }

    @Override
    protected void __accept(HttpConnection t, InputStream inputStream) {
        Runnable cleanup = () -> this.cleanup(this.useSongNames());
        Thread cleanupThread = new Thread(cleanup);
        Runtime.getRuntime().addShutdownHook(cleanupThread);
        try {
            int len;
            this.getStreamMetaData().setMetaDataConsumer(m -> {
                this.previousMetaData = this.metaData;
                this.metaData = m;
                this.metaDataChanged = true;
                new ConsoleMetaDataConsumer().accept((MetaData)m);
            });
            byte[] buffer = new byte[8192];
            Optional<MimeType> contentType = MimeType.byContentType(t.getContentType());
            if (!this.useSongNames()) {
                this.closeOldFileAndReopenWithNewMetadata(contentType.orElse(null));
            }
            long ofs = 0L;
            boolean dropMsgWritten = false;
            while (-1 != (len = inputStream.read(buffer))) {
                block15: {
                    try {
                        if (!this.needToAbort(this.fileNullable)) break block15;
                        return;
                    }
                    catch (IOException ioe) {
                        throw new RadioException(false, (Throwable)ioe);
                    }
                }
                if (this.metaDataChanged && this.useSongNames() && this.metaData.getIndex().orElse(0) > 0) {
                    this.closeOldFileAndReopenWithNewMetadata(contentType.orElse(null));
                }
                if (this.outputStreamNullable != null) {
                    this.outputStreamNullable.write(buffer, 0, len);
                } else if (!dropMsgWritten) {
                    log.info("Dropping bytes of incomplete file, waiting for next song");
                    dropMsgWritten = true;
                }
                log.trace("Copied {} bytes", (Object)(ofs += (long)len));
            }
        }
        catch (IOException ex) {
            log.warn("URL {} broke down", (Object)this.getContext().getUri().toASCIIString(), (Object)ex);
            ++this.fileNumber;
            throw new RadioException(true, (Throwable)ex);
        }
        finally {
            this.cleanup(this.useSongNames());
            Runtime.getRuntime().removeShutdownHook(cleanupThread);
        }
    }

    private void cleanup(boolean deletePartly) {
        if (this.outputStreamNullable != null) {
            try {
                this.outputStreamNullable.close();
            }
            catch (IOException ex) {
                log.warn("URL {} close error", (Object)this.getContext().getUri().toASCIIString(), (Object)ex);
            }
        }
        if (this.fileNullable != null && deletePartly && Files.exists(this.fileNullable, new LinkOption[0])) {
            log.info("Deleting partly file {}", (Object)this.fileNullable);
            try {
                Files.delete(this.fileNullable);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void closeStreamIfOpen(OutputStream outputStreamOrNull, Path fileOrNull, MimeType contentTypeOrNull) throws IOException {
        MetaData fileMetaData;
        MetaData metaData = fileMetaData = this.previousMetaData != null ? this.previousMetaData.clone() : null;
        if (outputStreamOrNull != null) {
            log.debug("Closing output stream to {}", (Object)fileOrNull);
            outputStreamOrNull.close();
            ID3Tagger idtagger = contentTypeOrNull == MimeType.AUDIO_MPEG && fileOrNull != null && fileMetaData != null ? new ID3Tagger(fileMetaData, fileOrNull) : null;
            Runnable postprocess = () -> {
                try {
                    if (fileOrNull != null && fileMetaData != null) {
                        Files.setLastModifiedTime(fileOrNull, FileTime.from(fileMetaData.getCreated().toInstant()));
                    }
                }
                catch (IOException e) {
                    log.warn("Error setting date for {}", (Object)fileOrNull, (Object)e);
                }
            };
            if (idtagger != null) {
                Thread postprocessThread = new Thread(() -> {
                    idtagger.run();
                    postprocess.run();
                }, "ID3 " + String.valueOf(fileOrNull));
                postprocessThread.start();
            } else {
                postprocess.run();
            }
        }
    }

    private void ensureParentDirectoriesExist(Path p) throws IOException {
        Path parent = p.getParent();
        if (!Files.exists(parent, new LinkOption[0])) {
            Files.createDirectories(parent, new FileAttribute[0]);
        }
    }
}

